/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.utils;

import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kb.gui.utils.TextErrorChecker;
import kb.utils.Observable;

public class ErrorAwareTextFieldBuilder {
    private JTextField textField;
    private TextErrorChecker errorChecker;
    private Observable<Boolean> changeObservable = new Observable();
    private Color textFieldBackground;
    private String correctStateTooltip;
    private String errorStateTooltip;

    public ErrorAwareTextFieldBuilder(JTextField textField, TextErrorChecker errorChecker) {
        this.textField = textField;
        this.errorChecker = errorChecker;
        this.textFieldBackground = textField.getBackground();
        this.addDocumentListener();
    }

    private void addDocumentListener() {
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ErrorAwareTextFieldBuilder.this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ErrorAwareTextFieldBuilder.this.textChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        });
    }

    private void textChanged() {
        this.adjustTextField();
        this.changeObservable.updateObservers(!this.errorChecker.isError(this.textField.getText()));
    }

    private void adjustTextField() {
        boolean error = this.errorChecker.isError(this.textField.getText());
        this.textField.setBackground(error ? Color.red : this.textFieldBackground);
        this.textField.setToolTipText(error ? this.errorStateTooltip : this.correctStateTooltip);
    }

    public Observable<Boolean> getChangeObservable() {
        return this.changeObservable;
    }

    public void setCorrectStateTooltip(String correctStateTooltip) {
        this.correctStateTooltip = correctStateTooltip;
    }

    public void setErrorStateTooltip(String errorStateTooltip) {
        this.errorStateTooltip = errorStateTooltip;
    }
}

