/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.utils;

import java.awt.Color;
import java.awt.Desktop;
import java.net.URI;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HyperLinkPane
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    private String hyperLink;
    private Mode mode;

    public HyperLinkPane(String hyperLink, Mode mode) {
        super("text/html", HyperLinkPane.createText(hyperLink, mode));
        this.hyperLink = hyperLink;
        this.mode = mode;
        this.init();
    }

    private static String createText(String hyperLink, Mode mode) {
        String link = mode == Mode.LINK ? hyperLink : "mailto:" + hyperLink;
        return "<div align=\"center\"><a href=\"" + link + "\">" + hyperLink + "</a></div>";
    }

    private void init() {
        this.setEditable(false);
        this.setOpaque(false);
        this.setBackground(new Color(0, 0, 0, 0));
        this.addHyperlinkListener(this.createHyperlinkListener());
    }

    private HyperlinkListener createHyperlinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    HyperLinkPane.this.hyperLinkActivated();
                }
            }
        };
    }

    private void hyperLinkActivated() {
        if (Desktop.isDesktopSupported()) {
            try {
                this.doHyperlinkAction();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void doHyperlinkAction() throws Exception {
        URI uri = new URI(this.mode == Mode.MAIL ? "mailto:" + this.hyperLink : this.hyperLink);
        if (this.mode == Mode.MAIL) {
            Desktop.getDesktop().mail(uri);
        } else if (this.mode == Mode.LINK) {
            Desktop.getDesktop().browse(uri);
        }
    }

    public static enum Mode {
        LINK,
        MAIL;

    }
}

