/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.utils;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kb.gui.GuiUtils;
import kb.gui.utils.XIcon;

public class MyTabComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton closeButton;
    private JLabel label;

    public MyTabComponent(String title, int mnemonic, ActionListener closeActionListener) {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.createCloseButton(closeActionListener);
        this.createLabel(title, mnemonic);
        this.addComponents();
    }

    private void createLabel(String title, int mnemonic) {
        this.label = new JLabel(String.valueOf(title) + " ");
        this.label.setDisplayedMnemonic(mnemonic);
    }

    private void createCloseButton(ActionListener actionListener) {
        this.closeButton = new JButton();
        this.closeButton.setIcon(new XIcon(this.closeButton.getModel()));
        this.closeButton.addActionListener(actionListener);
        this.closeButton.addActionListener(this.createMyActionListener());
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setFocusable(false);
        this.closeButton.setBorder(BorderFactory.createEtchedBorder());
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.setBorderPainted(false);
        this.closeButton.addMouseListener(this.createMouseListener());
        GuiUtils.setSize(this.closeButton, new Dimension(13, 13));
    }

    private ActionListener createMyActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyTabComponent.this.closeButton.setBorderPainted(false);
            }
        };
    }

    private MouseListener createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                MyTabComponent.this.closeButton.setBorderPainted(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MyTabComponent.this.closeButton.setBorderPainted(false);
            }
        };
    }

    private void addComponents() {
        this.addLabel();
        this.addButton();
    }

    private void addLabel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        this.add(this.label);
    }

    private void addButton() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        this.add(this.closeButton);
    }
}

