/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import kb.gui.GuiUtils;
import kb.gui.MyMouseListener;
import kb.gui.utils.MyTableCellRenderer;
import kb.gui.utils.TableCellDecorator;
import kb.gui.utils.TableRootRowSelectionListener;
import kb.utils.Observable;
import kb.utils.TableTextFieldFilter;

public class TablePanel<M extends TableModel>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private JScrollPane scrollPane;
    private JTextField textField;
    private JLabel filterFieldLabel;
    private Component actionsButton;
    private int columnIndex;
    private List<TableCellDecorator> decorators;
    private TableRootRowSelectionListener tableRootRowSelectionListener;
    private Observable<Integer> approvalObservable = new Observable();
    private Observable<int[]> deleteObservable = new Observable();

    TablePanel(JTable table, int columnIndex, JLabel filterFieldLabel, Component actionsButton, List<TableCellDecorator> decorators) {
        this.table = table;
        this.columnIndex = columnIndex;
        this.filterFieldLabel = filterFieldLabel;
        this.actionsButton = actionsButton;
        this.decorators = decorators;
        this.tableRootRowSelectionListener = new TableRootRowSelectionListener(table);
        this.createComponents();
        this.addComponents();
        this.enableFiltering();
        this.addKeyListeners();
        this.adjustTable();
        this.addActions();
    }

    private void addActions() {
        this.table.addMouseListener(this.createTableMouseListener());
        this.table.addKeyListener(this.createApprovalKeyListener());
        this.table.addKeyListener(this.createDeleteKeyListener());
        this.textField.addKeyListener(this.createApprovalKeyListener());
        this.textField.addFocusListener(this.createFilterFieldFocusListener());
    }

    private FocusListener createFilterFieldFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TablePanel.this.textField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TablePanel.this.textField.select(0, 0);
            }
        };
    }

    private void adjustTable() {
        this.table.setDefaultRenderer(String.class, this.createTableCellRenderer());
        this.table.setShowGrid(false);
    }

    private TableCellRenderer createTableCellRenderer() {
        MyTableCellRenderer result = new MyTableCellRenderer();
        if (this.table.getColumnCount() == 1) {
            result.addDecorator(this.createOneColumnTableDecorator());
        }
        this.addCustomDecorators(result);
        return result;
    }

    private void addCustomDecorators(MyTableCellRenderer renderer) {
        for (TableCellDecorator decorator : this.decorators) {
            renderer.addDecorator(decorator);
        }
    }

    private TableCellDecorator createOneColumnTableDecorator() {
        return new TableCellDecorator(){

            @Override
            public void decorate(Component component, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (!isSelected) {
                    component.setBackground(Color.WHITE);
                }
            }
        };
    }

    private void addKeyListeners() {
        this.addArrowListeners();
    }

    private void addArrowListeners() {
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TablePanel.this.textFieldKeyPressed(e);
            }
        });
    }

    private void textFieldKeyPressed(KeyEvent e) {
        this.handleTableSelectionChange(e);
        this.scrollToSelectedRow();
    }

    private void handleTableSelectionChange(KeyEvent e) {
        this.handleTableSelectionArrowKeys(e);
        this.handleTableSelectionHomeEndKeys(e);
    }

    private void handleTableSelectionHomeEndKeys(KeyEvent e) {
        int newSelectedRow;
        if (!e.isControlDown() || this.table.getRowCount() == 0) {
            return;
        }
        switch (e.getKeyCode()) {
            case 36: {
                newSelectedRow = 0;
                break;
            }
            case 35: {
                newSelectedRow = this.table.getRowCount() - 1;
                break;
            }
            default: {
                return;
            }
        }
        if (!e.isShiftDown()) {
            this.selectTableRow(newSelectedRow);
            return;
        }
        int rootSelectedRow = this.tableRootRowSelectionListener.getRootSelectedRow();
        if (rootSelectedRow < 0) {
            rootSelectedRow = 0;
        }
        this.selectTableRowsIntervalAccordingToRootSelectedRow(rootSelectedRow, newSelectedRow);
    }

    private void handleTableSelectionArrowKeys(KeyEvent e) {
        boolean shiftPressed = e.isShiftDown();
        switch (e.getKeyCode()) {
            case 38: {
                this.moveTableSelection(-1, shiftPressed);
                break;
            }
            case 40: {
                this.moveTableSelection(1, shiftPressed);
            }
        }
    }

    private void moveTableSelection(int increment, boolean shiftPressed) {
        if (this.table.getRowCount() == 0) {
            return;
        }
        if (this.table.getSelectedRow() < 0) {
            this.selectTableRow(0);
            return;
        }
        int rootSelectedRow = this.tableRootRowSelectionListener.getRootSelectedRow();
        int[] selectedRows = this.table.getSelectedRows();
        int selectedRow = selectedRows[0] < rootSelectedRow ? selectedRows[0] : selectedRows[selectedRows.length - 1];
        int newSelectedRow = selectedRow + increment;
        if (newSelectedRow > this.table.getRowCount() - 1 || newSelectedRow < 0) {
            return;
        }
        if (!shiftPressed) {
            this.selectTableRow(newSelectedRow);
            return;
        }
        this.selectTableRowsIntervalAccordingToRootSelectedRow(rootSelectedRow, newSelectedRow);
    }

    private void selectTableRowsIntervalAccordingToRootSelectedRow(int rootSelectedRow, int newSelectedRow) {
        int startRow = rootSelectedRow < newSelectedRow ? rootSelectedRow : newSelectedRow;
        int endRow = rootSelectedRow > newSelectedRow ? rootSelectedRow : newSelectedRow;
        this.selectTableRowsInterval(startRow, endRow);
    }

    private void scrollToSelectedRow() {
        if (this.table.getSelectedRow() != -1) {
            this.table.scrollRectToVisible(this.table.getCellRect(this.table.getSelectedRow(), 0, false));
        }
    }

    private void selectTableRow(int row) {
        this.table.getSelectionModel().setSelectionInterval(row, row);
    }

    private void selectTableRowsInterval(int startRow, int endRow) {
        this.table.getSelectionModel().setSelectionInterval(startRow, endRow);
    }

    private void createComponents() {
        this.createTextField();
    }

    private void createTextField() {
        this.textField = new JTextField();
        GuiUtils.setSize(this.textField, new Dimension(50, 25));
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addFilterFieldLabel();
        this.addTextField();
        if (this.hasActionsButton()) {
            this.addActionsButton();
        }
        this.addTable();
    }

    private boolean hasActionsButton() {
        return this.actionsButton != null;
    }

    private void addFilterFieldLabel() {
        if (this.hasFilterFieldLabel()) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(0, 3, 3, 0);
            c.fill = 2;
            this.add((Component)this.filterFieldLabel, c);
            this.filterFieldLabel.setLabelFor(this.textField);
        }
    }

    private boolean hasFilterFieldLabel() {
        return this.filterFieldLabel != null;
    }

    private void addActionsButton() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = this.hasFilterFieldLabel() ? 2 : 1;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 3, 0);
        c.fill = 2;
        this.add(this.actionsButton, c);
    }

    private void addTextField() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = this.hasFilterFieldLabel() ? 1 : 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.textField, c);
    }

    private void addTable() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = this.hasFilterFieldLabel() ? 3 : 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.scrollPane = new JScrollPane(this.table);
        this.add((Component)this.scrollPane, c);
    }

    private void enableFiltering() {
        TableRowSorter<M> tableRowSorter = new TableRowSorter<M>(this.getTableModel());
        this.table.setRowSorter(tableRowSorter);
        this.disableSorting(tableRowSorter);
        new TableTextFieldFilter(this.textField, tableRowSorter, this.columnIndex);
    }

    private void disableSorting(TableRowSorter<M> tableRowSorter) {
        int i = 0;
        int n = this.getTableModel().getColumnCount();
        while (i < n) {
            tableRowSorter.setSortable(i, false);
            ++i;
        }
    }

    private M getTableModel() {
        return (M)this.table.getModel();
    }

    public void clearFilter() {
        this.textField.setText("");
        this.textField.requestFocusInWindow();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public Observable<Integer> getApprovalObservable() {
        return this.approvalObservable;
    }

    public Observable<int[]> getDeleteObservable() {
        return this.deleteObservable;
    }

    private MouseListener createTableMouseListener() {
        return new MyMouseListener(){

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
                TablePanel.this.selectionApproved();
            }
        };
    }

    private void selectionApproved() {
        this.selectFirstRowIfNoRowSelected();
        if (this.table.getSelectedRow() >= 0) {
            this.approvalObservable.updateObservers(this.table.getSelectedRow());
        }
    }

    private void selectFirstRowIfNoRowSelected() {
        if (this.table.getRowCount() > 0 && this.table.getSelectedRow() < 0) {
            this.selectTableRow(0);
        }
    }

    public void focusFilterField() {
        this.textField.requestFocusInWindow();
    }

    private KeyAdapter createApprovalKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    if (e.getModifiers() == 0) {
                        TablePanel.this.selectionApproved();
                    }
                }
            }
        };
    }

    private KeyAdapter createDeleteKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    TablePanel.this.deleteKeyPressed();
                }
            }
        };
    }

    private void deleteKeyPressed() {
        if (this.table.getSelectedRow() >= 0) {
            this.deleteObservable.updateObservers(this.table.getSelectedRows());
        }
    }
}

