/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import kb.gui.ActionsButtonBuilder;
import kb.gui.MyMouseListener;
import kb.gui.PopupMenuUtils;
import kb.gui.utils.TableCellDecorator;
import kb.gui.utils.TablePanel;
import kb.gui.utils.TablePanelPopupMenusHolder;

public class TablePanelBuilder<M extends TableModel> {
    private final JTable table;
    private int filterColumnIndex = 0;
    private TablePanelPopupMenusHolder popupMenusHolder;
    private String filterFieldLabelText;
    private int filterFieldLabelMnemonic = -1;
    private int actionsButtonMnemonic = -1;
    private Component customActionsComponent;
    private List<TableCellDecorator> decorators = new ArrayList<TableCellDecorator>();

    public TablePanelBuilder(JTable table) {
        this.table = table;
    }

    private void addTableContextMenuListener() {
        this.table.addMouseListener(new MyMouseListener(){

            @Override
            public void contextMenuTriggered(MouseEvent e) {
                TablePanelBuilder.this.tableContextMenuTriggered(e);
            }
        });
    }

    private void tableContextMenuTriggered(MouseEvent e) {
        this.selectClickedTableRowIfNotAlreadySelected(e);
        if (this.hasContextMenu()) {
            this.displayContextMenu(e);
        }
    }

    private void selectClickedTableRowIfNotAlreadySelected(MouseEvent e) {
        int rowToSelect = this.table.rowAtPoint(e.getPoint());
        if (!this.isRowSelected(rowToSelect)) {
            this.table.getSelectionModel().setSelectionInterval(rowToSelect, rowToSelect);
        }
    }

    private boolean isRowSelected(int row) {
        int[] nArray = this.table.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int selectedRow = nArray[n2];
            if (row == selectedRow) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void displayContextMenu(MouseEvent e) {
        this.popupMenusHolder.getContextMenu().show(this.table, e.getX(), e.getY());
    }

    public TablePanel<M> build() {
        this.addTableContextMenuListener();
        if (this.hasContextMenu()) {
            PopupMenuUtils.addGlobalPopupMenuListener(this.popupMenusHolder.getContextMenu());
        }
        return new TablePanel(this.table, this.filterColumnIndex, this.createFilterFieldLabel(), this.createActionsComponent(), this.decorators);
    }

    private Component createActionsComponent() {
        if (this.hasActionsMenu()) {
            return this.createActionsButton();
        }
        if (this.customActionsComponent != null) {
            return this.customActionsComponent;
        }
        return null;
    }

    private Component createActionsButton() {
        ActionsButtonBuilder builder = new ActionsButtonBuilder(this.popupMenusHolder.getActionsMenu()).setText("Actions").setSize(new Dimension(90, 25));
        if (this.hasActionsButtonMnemonic()) {
            builder.setMnemonic(this.actionsButtonMnemonic);
        }
        return builder.build();
    }

    private boolean hasActionsButtonMnemonic() {
        return this.actionsButtonMnemonic >= 0;
    }

    private boolean hasActionsMenu() {
        return this.popupMenusHolder != null && this.popupMenusHolder.getActionsMenu() != null;
    }

    private boolean hasContextMenu() {
        return this.popupMenusHolder != null && this.popupMenusHolder.getContextMenu() != null;
    }

    private JLabel createFilterFieldLabel() {
        if (this.hasFilterFieldLabelText()) {
            JLabel result = new JLabel(String.valueOf(this.filterFieldLabelText) + " ");
            this.setDisplayedMnemonic(result);
            return result;
        }
        return null;
    }

    private void setDisplayedMnemonic(JLabel label) {
        if (this.hasFieldLabelMnemonic()) {
            label.setDisplayedMnemonic(this.filterFieldLabelMnemonic);
        }
    }

    private boolean hasFieldLabelMnemonic() {
        return this.filterFieldLabelMnemonic >= 0;
    }

    private boolean hasFilterFieldLabelText() {
        return this.filterFieldLabelText != null && !this.filterFieldLabelText.trim().isEmpty();
    }

    public TablePanelBuilder<M> setFilterColumnIndex(int filterColumnIndex) {
        this.filterColumnIndex = filterColumnIndex;
        return this;
    }

    public TablePanelBuilder<M> setPopupMenusHolder(TablePanelPopupMenusHolder popupMenusHolder) {
        this.popupMenusHolder = popupMenusHolder;
        return this;
    }

    public TablePanelBuilder<M> setFilterFieldLabelText(String filterFieldLabelText) {
        this.filterFieldLabelText = filterFieldLabelText;
        return this;
    }

    public TablePanelBuilder<M> setFilterFieldLabelMnemonic(int textFieldLabelMnemonic) {
        this.filterFieldLabelMnemonic = textFieldLabelMnemonic;
        return this;
    }

    public TablePanelBuilder<M> setActionsButtonMnemonic(int actionsButtonMnemonic) {
        this.actionsButtonMnemonic = actionsButtonMnemonic;
        return this;
    }

    public TablePanelBuilder<M> setCustomActionsComponent(Component customActionsComponent) {
        this.customActionsComponent = customActionsComponent;
        return this;
    }

    public TablePanelBuilder<M> addTableCellDecorator(TableCellDecorator decorator) {
        this.decorators.add(decorator);
        return this;
    }
}

