/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.utils;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import kb.gui.utils.TextComponentContextMenuHandler;

public class TextAreaComponent {
    private JPanel panel;
    private JTextArea textArea;
    private JCheckBox chkLineWrap;
    private JCheckBoxMenuItem miLineWrap;

    public TextAreaComponent() {
        this.createComponents();
        this.addComponents();
        this.addActions();
    }

    private void addActions() {
        this.chkLineWrap.addActionListener(new LineWrapChangeListener(this.miLineWrap));
        this.miLineWrap.addActionListener(new LineWrapChangeListener(this.chkLineWrap));
    }

    private void createComponents() {
        this.panel = new JPanel(new GridBagLayout());
        this.miLineWrap = new JCheckBoxMenuItem("Line wrap");
        this.textArea = this.createTextArea();
        this.chkLineWrap = this.createChkLineWrap();
    }

    private JTextArea createTextArea() {
        JTextArea result = new JTextArea();
        result.setTabSize(2);
        this.addContextMenu(result);
        return result;
    }

    private void addContextMenu(JTextArea result) {
        JPopupMenu popupMenu = TextComponentContextMenuHandler.addContextMenu(result);
        popupMenu.addSeparator();
        popupMenu.add(this.miLineWrap);
    }

    private JCheckBox createChkLineWrap() {
        JCheckBox result = new JCheckBox("Line wrap");
        result.setMnemonic(76);
        return result;
    }

    private void addComponents() {
        this.addTextArea();
        this.addChkLineWrap();
    }

    private void addTextArea() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panel.add((Component)new JScrollPane(this.textArea), c);
    }

    private void addChkLineWrap() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.panel.add((Component)this.chkLineWrap, c);
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public Component getComponent() {
        return this.panel;
    }

    public void setLineWrapCheckBoxVisible(boolean visible) {
        this.chkLineWrap.setVisible(visible);
    }

    public void setLineWrap(boolean lineWrap) {
        this.chkLineWrap.setSelected(lineWrap);
        this.miLineWrap.setSelected(lineWrap);
        this.setTextAreaLineWrap(lineWrap);
    }

    private void setTextAreaLineWrap(boolean lineWrap) {
        this.textArea.setLineWrap(lineWrap);
        this.textArea.setWrapStyleWord(lineWrap);
    }

    public boolean isLineWrap() {
        return this.textArea.getLineWrap();
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    private class LineWrapChangeListener
    implements ActionListener {
        private AbstractButton pairedButton;

        public LineWrapChangeListener(AbstractButton pairButton) {
            this.pairedButton = pairButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean selected = ((AbstractButton)e.getSource()).isSelected();
            TextAreaComponent.this.setLineWrap(selected);
            this.pairedButton.setSelected(selected);
        }
    }
}

