/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.text.JTextComponent;
import kb.ClipboardManager;
import kb.clipboard.ClipboardAcessor;
import kb.gui.PopupMenuUtils;
import kb.utils.PopupMenuAdapter;

class TextComponentContextMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private JTextComponent textComponent;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem selectAllMenuItem;

    public TextComponentContextMenu(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.createMenusItems();
        this.addMenuItems();
        this.addMenuVisibilityListener();
        PopupMenuUtils.addGlobalPopupMenuListener(this);
    }

    private void addMenuVisibilityListener() {
        this.addPopupMenuListener(new PopupMenuAdapter(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
                TextComponentContextMenu.this.setMenuItemsEnableState();
            }
        });
    }

    private void setMenuItemsEnableState() {
        this.cutMenuItem.setEnabled(this.textComponent.isEditable() && !this.isEmpty(this.textComponent.getSelectedText()));
        this.copyMenuItem.setEnabled(!this.isEmpty(this.textComponent.getSelectedText()));
        this.pasteMenuItem.setEnabled(this.textComponent.isEditable() && !this.isEmpty(ClipboardAcessor.getClipboardText()));
        this.selectAllMenuItem.setEnabled(!this.isEmpty(this.textComponent.getText()));
    }

    private void createMenusItems() {
        this.cutMenuItem = this.createMenuItem("Cut", this.createCutActionListener());
        this.copyMenuItem = this.createMenuItem("Copy", this.createCopyActionListener());
        this.pasteMenuItem = this.createMenuItem("Paste", this.createPasteActionListener());
        this.selectAllMenuItem = this.createMenuItem("Select All", this.createSelectAllActionListener());
    }

    private ActionListener createCopyActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextComponentContextMenu.this.copySelectedText();
            }
        };
    }

    private ActionListener createPasteActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextComponentContextMenu.this.paste();
            }
        };
    }

    private ActionListener createSelectAllActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextComponentContextMenu.this.selectAll();
            }
        };
    }

    private ActionListener createCutActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextComponentContextMenu.this.cutSelectedText();
            }
        };
    }

    private void cutSelectedText() {
        String selectedText = this.textComponent.getSelectedText();
        if (!this.isEmpty(selectedText)) {
            this.copyToClipboard(selectedText);
            this.textComponent.replaceSelection("");
        }
    }

    private void copySelectedText() {
        String selectedText = this.textComponent.getSelectedText();
        if (!this.isEmpty(selectedText)) {
            this.copyToClipboard(selectedText);
        }
    }

    private void copyToClipboard(String text) {
        ClipboardManager.getInstance().copyToClipboard(text);
    }

    private void paste() {
        String text = ClipboardAcessor.getClipboardText();
        if (!this.isEmpty(text)) {
            this.textComponent.replaceSelection(text);
        }
    }

    private void selectAll() {
        this.textComponent.selectAll();
    }

    private boolean isEmpty(String aString) {
        return aString == null || aString.isEmpty();
    }

    private JMenuItem createMenuItem(String text, ActionListener actionListener) {
        JMenuItem result = new JMenuItem(text);
        result.addActionListener(actionListener);
        return result;
    }

    private void addMenuItems() {
        this.add(this.cutMenuItem);
        this.add(this.copyMenuItem);
        this.add(this.pasteMenuItem);
        this.addSeparator();
        this.add(this.selectAllMenuItem);
    }
}

