/*
 * Decompiled with CFR 0.152.
 */
package kb.utils;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import kb.utils.ExecutorServices;
import kb.utils.Utils;

public class ObjectIO {
    public void writeText(final String text, final String filePath) {
        ExecutorServices.FILE_OPERATIONS_EXECUTOR_SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                ObjectIO.this.createDirIfNotExists(filePath);
                ObjectIO.this.doWriteText(text, filePath);
            }
        });
    }

    private void createDirIfNotExists(String filePath) {
        File dir = new File(filePath).getParentFile();
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    private void doWriteText(String text, String filePath) {
        block5: {
            BufferedWriter out = null;
            try {
                try {
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
                    this.write(text, out);
                }
                catch (IOException iOException) {
                    Utils.close(out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Utils.close(out);
                throw throwable;
            }
            Utils.close(out);
        }
    }

    private void write(String text, BufferedWriter out) throws IOException {
        boolean first = true;
        String[] stringArray = Utils.getLines(text);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (first) {
                first = false;
            } else {
                out.newLine();
            }
            out.write(line);
            ++n2;
        }
    }

    public String readText(String filePath) {
        try {
            return this.submitTextFileRead(filePath).get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Future<String> submitTextFileRead(final String filePath) {
        return ExecutorServices.FILE_OPERATIONS_EXECUTOR_SERVICE.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ObjectIO.this.doReadText(filePath);
            }
        });
    }

    /*
     * Loose catch block
     */
    private String doReadText(String filePath) {
        String string;
        BufferedReader in = null;
        try {
            StringBuilder resultBuilder = new StringBuilder();
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
            this.read(in, resultBuilder);
            string = resultBuilder.toString();
        }
        catch (IOException e) {
            Utils.close(in);
            return null;
            catch (Throwable throwable) {
                Utils.close(in);
                throw throwable;
            }
        }
        Utils.close(in);
        return string;
    }

    private void read(BufferedReader in, StringBuilder resultBuilder) throws IOException {
        String str;
        boolean first = true;
        while ((str = in.readLine()) != null) {
            if (first) {
                first = false;
            } else {
                resultBuilder.append("\n");
            }
            resultBuilder.append(str);
        }
    }

    public void delete(final String fileName) {
        ExecutorServices.FILE_OPERATIONS_EXECUTOR_SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                new File(fileName).delete();
            }
        });
    }

    public void saveImage(final Image image, final String filePath) {
        ExecutorServices.FILE_OPERATIONS_EXECUTOR_SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                ObjectIO.this.createDirIfNotExists(filePath);
                ObjectIO.this.doSaveImage(image, filePath);
            }
        });
    }

    private void doSaveImage(Image image, String filePath) {
        try {
            ImageIO.write((RenderedImage)Utils.toBufferedImage(image), "png", new File(filePath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Image readImage(String filePath) {
        try {
            return this.submitImageFileRead(filePath).get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Future<Image> submitImageFileRead(final String filePath) {
        return ExecutorServices.FILE_OPERATIONS_EXECUTOR_SERVICE.submit(new Callable<Image>(){

            @Override
            public Image call() throws Exception {
                return ObjectIO.this.doReadImage(filePath);
            }
        });
    }

    private Image doReadImage(String filePath) {
        try {
            return ImageIO.read(new File(filePath));
        }
        catch (IOException e) {
            return null;
        }
    }

    public void savePreviewImage(final Image image, final String filePath) {
        ExecutorServices.FILE_OPERATIONS_EXECUTOR_SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                ObjectIO.this.createDirIfNotExists(filePath);
                ObjectIO.this.doSavePreviewImage(image, filePath);
            }
        });
    }

    private void doSavePreviewImage(Image image, String filePath) {
        try {
            ImageIO.write((RenderedImage)Utils.toBufferedImage(new ImageIcon(Utils.scale(image, 300, 80)).getImage()), "png", new File(filePath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

