/*
 * Decompiled with CFR 0.152.
 */
package kb.utils;

import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableRowSorter;

public class TableTextFieldFilter {
    private JTextField textField;
    private TableRowSorter<?> tableRowSorter;
    private int filterColumn;
    private String filterText;

    public TableTextFieldFilter(JTextField textField, TableRowSorter<?> tableRowSorter, int filterColumn) {
        this.textField = textField;
        this.tableRowSorter = tableRowSorter;
        this.filterColumn = filterColumn;
        tableRowSorter.setRowFilter(this.createRowFilter());
        this.addDocumentListener(textField);
    }

    private RowFilter<Object, Integer> createRowFilter() {
        return new RowFilter<Object, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends Object, ? extends Integer> entry) {
                String value;
                if (TableTextFieldFilter.this.filterText == null || TableTextFieldFilter.this.filterText.isEmpty()) {
                    return true;
                }
                String string = value = entry.getValue(TableTextFieldFilter.this.filterColumn) == null ? null : entry.getValue(TableTextFieldFilter.this.filterColumn).toString().trim();
                if (value == null || value.length() < TableTextFieldFilter.this.filterText.length()) {
                    return false;
                }
                return value.substring(0, TableTextFieldFilter.this.filterText.length()).equalsIgnoreCase(TableTextFieldFilter.this.filterText);
            }
        };
    }

    private void addDocumentListener(JTextField textField) {
        textField.getDocument().addDocumentListener(this.createDocumentListener());
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TableTextFieldFilter.this.filter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TableTextFieldFilter.this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        };
    }

    private void filter() {
        this.filterText = this.textField.getText().trim();
        this.tableRowSorter.sort();
    }
}

