/*
 * Decompiled with CFR 0.152.
 */
package kb.utils;

import java.util.ArrayList;
import java.util.List;

public abstract class TrialAndErrorOperation<T> {
    private final int trialCount;
    private List<Throwable> exceptions = new ArrayList<Throwable>();
    private boolean operationSuccessful = false;

    public TrialAndErrorOperation(int trialCount) {
        this.trialCount = trialCount;
    }

    public final T execute() {
        int i = 0;
        while (i < this.trialCount) {
            try {
                T result = this.executeOperation();
                this.operationSuccessful = true;
                return result;
            }
            catch (Throwable e) {
                this.exceptions.add(e);
                this.onFailure(e);
                ++i;
            }
        }
        return this.onOperationFailure();
    }

    protected void onFailure(Throwable e) {
    }

    protected T onOperationFailure() {
        return null;
    }

    public final List<Throwable> getExceptions() {
        return this.exceptions;
    }

    public final boolean wasOperationSuccessful() {
        return this.operationSuccessful;
    }

    protected abstract T executeOperation() throws Throwable;
}

