/*
 * Decompiled with CFR 0.152.
 */
package kb.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;

public final class Utils {
    private Utils() {
        throw new UnsupportedOperationException();
    }

    public static void sleepIgnoreInterrupt(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean areAllElementsCorrectlyTyped(List<?> list, Class<?> clazz) {
        for (Object obj : list) {
            if (clazz.isAssignableFrom(obj.getClass())) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqualsNullsIncluded(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        return o1 != null && o1.equals(o2);
    }

    public static String[] getLines(String text) {
        String[] result = text.split("\n");
        int trailingEmptyLinesCount = Utils.getTrailingEmptyLinesCount(text);
        return trailingEmptyLinesCount > 0 ? Utils.appendEmptyLines(result, trailingEmptyLinesCount) : result;
    }

    private static int getTrailingEmptyLinesCount(String text) {
        int result = 0;
        int i = text.length() - 1;
        while (i >= 0) {
            if (text.charAt(i) == '\n') {
                ++result;
            } else {
                return result;
            }
            --i;
        }
        return result;
    }

    private static String[] appendEmptyLines(String[] lines, int trailingEmptyLinesCount) {
        String[] result = Arrays.copyOf(lines, lines.length + trailingEmptyLinesCount);
        int i = result.length - trailingEmptyLinesCount;
        while (i < result.length) {
            result[i] = "";
            ++i;
        }
        return result;
    }

    public static Image getImage(String path) {
        return Toolkit.getDefaultToolkit().createImage(Thread.class.getResource("/" + path));
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        return Utils.createBufferedImage(image);
    }

    private static BufferedImage createBufferedImage(Image image) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        int type = 1;
        BufferedImage result = new BufferedImage(w, h, type);
        Graphics2D g2 = result.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return result;
    }

    public static byte[] getByteArray(Image image) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)Utils.toBufferedImage(image), "png", output);
            return output.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Image scale(Image image, int maxWidth, int maxHeight) {
        double heightRatio;
        if (image.getWidth(null) <= maxWidth && image.getHeight(null) <= maxHeight) {
            return image;
        }
        double widthRatio = (double)maxWidth / (double)image.getWidth(null);
        if (widthRatio < (heightRatio = (double)maxHeight / (double)image.getHeight(null))) {
            return image.getScaledInstance(maxWidth, -1, 4);
        }
        return image.getScaledInstance(-1, maxHeight, 4);
    }

    public static <T> List<T> toList(T ... elements) {
        return new ArrayList<T>(Arrays.asList(elements));
    }
}

