/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer;

import com.koutra.dist.proc.designer.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class ProcessWizardFirstPage
extends WizardNewFileCreationPage {
    private static final String DEFAULT_EXTENSION = ".proc";
    private static int fileCount = 1;
    private final IWorkbench workbench;

    public ProcessWizardFirstPage(IWorkbench workbench, IStructuredSelection selection) {
        super(Messages.ProcessWizardFirstPage_PageName, selection);
        this.workbench = workbench;
        this.setTitle(MessageFormat.format(Messages.ProcessWizardFirstPage_Title, DEFAULT_EXTENSION));
        this.setDescription(MessageFormat.format(Messages.ProcessWizardFirstPage_Description, DEFAULT_EXTENSION));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName(MessageFormat.format(Messages.ProcessWizardFirstPage_FileNamePattern, String.valueOf(fileCount) + DEFAULT_EXTENSION));
        this.setPageComplete(this.validatePage());
    }

    boolean finish() {
        IFile newFile = this.createNewFile();
        ++fileCount;
        IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
        if (newFile != null && page != null) {
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
            catch (PartInitException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    protected InputStream getInitialContents() {
        ByteArrayInputStream bais = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes());
            baos.write("<process/>".getBytes());
            bais = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return bais;
    }

    private boolean validateFilename() {
        if (this.getFileName() != null && this.getFileName().endsWith(DEFAULT_EXTENSION)) {
            return true;
        }
        this.setErrorMessage(MessageFormat.format(Messages.ProcessWizardFirstPage_IncorrectFileExtension, DEFAULT_EXTENSION));
        return false;
    }

    protected boolean validatePage() {
        return super.validatePage() && this.validateFilename();
    }
}

