/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.editor;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.editor.ProcessEditorContextMenuProvider;
import com.koutra.dist.proc.designer.editor.ProcessEditorPaletteFactory;
import com.koutra.dist.proc.designer.editor.parts.ProcessEditPartFactory;
import com.koutra.dist.proc.designer.editor.parts.ProcessTreeEditPartFactory;
import com.koutra.dist.proc.designer.model.Process;
import com.koutra.dist.proc.designer.model.ProcessStep;
import com.koutra.dist.proc.designer.model.ValidationError;
import com.koutra.dist.proc.designer.utils.DesignerLog;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ProcessEditor
extends GraphicalEditorWithFlyoutPalette {
    private Process process;
    private static PaletteRoot PALETTE_MODEL;

    public ProcessEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new ProcessEditPartFactory());
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
        ProcessEditorContextMenuProvider cmProvider = new ProcessEditorContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu((MenuManager)cmProvider, (ISelectionProvider)viewer);
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    private TransferDropTargetListener createTransferDropTargetListener() {
        return new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()){

            protected CreationFactory getFactory(Object template) {
                return new SimpleFactory((Class)template);
            }
        };
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            Process.dehydrate(file, this.process, monitor);
            this.getCommandStack().markSaveLocation();
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void doSaveAs() {
        Shell shell = this.getSite().getWorkbenchWindow().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path != null) {
            final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            try {
                new ProgressMonitorDialog(shell).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) {
                        try {
                            Process.dehydrate(file, ProcessEditor.this.process, monitor);
                        }
                        catch (CoreException ce) {
                            ce.printStackTrace();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                });
                this.setInput((IEditorInput)new FileEditorInput(file));
                this.getCommandStack().markSaveLocation();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
        }
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return new ShapesOutlinePage((EditPartViewer)new TreeViewer());
        }
        return super.getAdapter(type);
    }

    public Process getModel() {
        return this.process;
    }

    protected EditPart getPartFor(ProcessStep step) {
        List steps = this.getGraphicalViewer().getContents().getChildren();
        for (Object s : steps) {
            EditPart editPart = (EditPart)s;
            if (editPart.getModel() != step) continue;
            return editPart;
        }
        return null;
    }

    public String validate() {
        List<ValidationError> validationErrors = this.process.validate();
        if (validationErrors.size() == 0) {
            return null;
        }
        ValidationError error = validationErrors.get(0);
        EditPart childEditPart = this.getPartFor((ProcessStep)error.getElement());
        this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection((Object)childEditPart));
        return String.valueOf(Messages.ProcessEditor_ValidationErrorPreamble) + error.getErrorMessage();
    }

    protected PaletteRoot getPaletteRoot() {
        if (PALETTE_MODEL == null) {
            PALETTE_MODEL = ProcessEditorPaletteFactory.createPalette();
        }
        return PALETTE_MODEL;
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)this.getModel());
        viewer.addDropTargetListener(this.createTransferDropTargetListener());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        try {
            IFile file = ((IFileEditorInput)input).getFile();
            this.process = Process.hydrate(file);
            this.setPartName(file.getName());
        }
        catch (Exception e) {
            DesignerLog.logError("Unable to load input", e);
        }
    }

    public class ShapesOutlinePage
    extends ContentOutlinePage {
        public ShapesOutlinePage(EditPartViewer viewer) {
            super(viewer);
        }

        public void createControl(Composite parent) {
            this.getViewer().createControl(parent);
            this.getViewer().setEditDomain((EditDomain)ProcessEditor.this.getEditDomain());
            this.getViewer().setEditPartFactory((EditPartFactory)new ProcessTreeEditPartFactory());
            ProcessEditorContextMenuProvider cmProvider = new ProcessEditorContextMenuProvider(this.getViewer(), ProcessEditor.this.getActionRegistry());
            this.getViewer().setContextMenu((MenuManager)cmProvider);
            this.getSite().registerContextMenu("org.eclipse.gef.examples.shapes.outline.contextmenu", (MenuManager)cmProvider, this.getSite().getSelectionProvider());
            ProcessEditor.this.getSelectionSynchronizer().addViewer(this.getViewer());
            this.getViewer().setContents((Object)ProcessEditor.this.getModel());
        }

        public void dispose() {
            ProcessEditor.this.getSelectionSynchronizer().removeViewer(this.getViewer());
            super.dispose();
        }

        public Control getControl() {
            return this.getViewer().getControl();
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            ActionRegistry registry = ProcessEditor.this.getActionRegistry();
            IActionBars bars = pageSite.getActionBars();
            String id = ActionFactory.UNDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.REDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.DELETE.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        }
    }
}

