/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.editor.command;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.model.Connection;
import com.koutra.dist.proc.designer.model.IFaucet;
import com.koutra.dist.proc.designer.model.ISink;
import com.koutra.dist.proc.designer.model.SplitPipelineItem;
import com.koutra.dist.proc.designer.model.SplitTemplate;
import org.eclipse.gef.commands.Command;

public class ConnectionCreateCommand
extends Command {
    private Connection connection;
    private final IFaucet source;
    private ISink target;

    public ConnectionCreateCommand(IFaucet source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel(Messages.ConnectionCreateCommand_Label);
        this.source = source;
    }

    public IFaucet getSource() {
        return this.source;
    }

    public boolean canExecute() {
        if (this.source.equals(this.target)) {
            return false;
        }
        if (this.source instanceof SplitPipelineItem) {
            SplitPipelineItem pipelineItem = (SplitPipelineItem)this.source;
            for (Connection c : pipelineItem.getCopyOfSinkConnections()) {
                if (c.getSink() == null || !c.getSink().equals(this.target)) continue;
                return false;
            }
        } else if (this.source instanceof SplitTemplate) {
            SplitTemplate template = (SplitTemplate)this.source;
            for (Connection c : template.getCopyOfSinkConnections()) {
                if (c.getSink() == null || !c.getSink().equals(this.target)) continue;
                return false;
            }
        } else if (this.source.getSinkConnection() != null && this.source.getSinkConnection().getSink() != null && this.source.getSinkConnection().getSink().equals(this.target)) {
            return false;
        }
        return true;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        this.connection = new Connection();
        this.connection.connect(this.source, this.target);
    }

    public void setTarget(ISink target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.target = target;
    }

    public void undo() {
        this.connection.disconnect();
    }
}

