/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.editor.command;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.model.Connection;
import com.koutra.dist.proc.designer.model.IFaucet;
import com.koutra.dist.proc.designer.model.ISink;
import com.koutra.dist.proc.designer.model.SplitPipelineItem;
import com.koutra.dist.proc.designer.model.SplitTemplate;
import org.eclipse.gef.commands.Command;

public class ConnectionReconnectCommand
extends Command {
    private Connection connection;
    private IFaucet newSource;
    private ISink newTarget;
    private final IFaucet oldSource;
    private final ISink oldTarget;

    public ConnectionReconnectCommand(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        this.connection = conn;
        this.oldSource = conn.getFaucet();
        this.oldTarget = conn.getSink();
    }

    public IFaucet getOldSource() {
        return this.oldSource;
    }

    public ISink getOldTarget() {
        return this.oldTarget;
    }

    public boolean canExecute() {
        if (this.newSource != null) {
            return this.checkSourceReconnection();
        }
        if (this.newTarget != null) {
            return this.checkTargetReconnection();
        }
        return false;
    }

    private boolean checkSourceReconnection() {
        if (this.newSource.equals(this.oldTarget)) {
            return false;
        }
        if (this.newSource instanceof SplitPipelineItem) {
            SplitPipelineItem pipelineItem = (SplitPipelineItem)this.newSource;
            for (Connection c : pipelineItem.getCopyOfSinkConnections()) {
                if (c.getSink() == null || !c.getSink().equals(this.oldTarget)) continue;
                return false;
            }
        } else if (this.newSource instanceof SplitTemplate) {
            SplitTemplate template = (SplitTemplate)this.newSource;
            for (Connection c : template.getCopyOfSinkConnections()) {
                if (c.getSink() == null || !c.getSink().equals(this.oldTarget)) continue;
                return false;
            }
        } else if (this.newSource.getSinkConnection() != null && this.newSource.getSinkConnection().getSink() != null && this.newSource.getSinkConnection().getSink().equals(this.oldTarget)) {
            return false;
        }
        return true;
    }

    private boolean checkTargetReconnection() {
        if (this.newTarget.equals(this.oldSource)) {
            return false;
        }
        if (this.oldSource instanceof SplitPipelineItem) {
            SplitPipelineItem pipelineItem = (SplitPipelineItem)this.oldSource;
            for (Connection c : pipelineItem.getCopyOfSinkConnections()) {
                if (c.getSink() == null || !c.getSink().equals(this.newTarget)) continue;
                return false;
            }
        } else if (this.oldSource instanceof SplitTemplate) {
            SplitTemplate template = (SplitTemplate)this.oldSource;
            for (Connection c : template.getCopyOfSinkConnections()) {
                if (c.getSink() == null || !c.getSink().equals(this.newTarget)) continue;
                return false;
            }
        } else if (this.oldSource.getSinkConnection() != null && this.oldSource.getSinkConnection().getSink() != null && this.oldSource.getSinkConnection().getSink().equals(this.newTarget)) {
            return false;
        }
        return true;
    }

    public void execute() {
        if (this.newSource != null) {
            this.connection.connect(this.newSource, this.oldTarget);
        } else if (this.newTarget != null) {
            this.connection.connect(this.oldSource, this.newTarget);
        } else {
            throw new IllegalStateException("Should not happen");
        }
    }

    public void setNewSource(IFaucet connectionSource) {
        if (connectionSource == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel(Messages.ConnectionReconnectCommand_MoveStartLabel);
        this.newSource = connectionSource;
        this.newTarget = null;
    }

    public void setNewTarget(ISink connectionTarget) {
        if (connectionTarget == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel(Messages.ConnectionReconnectCommand_MoveEndLabel);
        this.newSource = null;
        this.newTarget = connectionTarget;
    }

    public void undo() {
        this.connection.connect(this.oldSource, this.oldTarget);
    }
}

