/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.editor.command;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.model.Process;
import com.koutra.dist.proc.designer.model.ProcessStep;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class ProcessStepCreateCommand
extends Command {
    private ProcessStep newStep;
    private final Process parent;
    private Rectangle bounds;

    public ProcessStepCreateCommand(ProcessStep newStep, Process parent, Rectangle bounds) {
        this.newStep = newStep;
        this.parent = parent;
        this.bounds = bounds;
        this.setLabel(Messages.ProcessStepCreateCommand_Label);
    }

    public boolean canExecute() {
        return this.newStep != null && this.parent != null && this.bounds != null;
    }

    public void execute() {
        this.newStep.setLocation(this.bounds.getLocation());
        Dimension size = this.bounds.getSize();
        if (size.width > 0 && size.height > 0) {
            this.newStep.setSize(size);
        }
        this.redo();
    }

    public void redo() {
        this.parent.add(this.newStep);
    }

    public void undo() {
        this.parent.removeChild(this.newStep);
    }
}

