/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.editor.command;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.model.Connection;
import com.koutra.dist.proc.designer.model.IFaucet;
import com.koutra.dist.proc.designer.model.ISink;
import com.koutra.dist.proc.designer.model.Process;
import com.koutra.dist.proc.designer.model.ProcessStep;
import com.koutra.dist.proc.designer.model.SplitPipelineItem;
import com.koutra.dist.proc.designer.model.SplitTemplate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class ProcessStepDeleteCommand
extends Command {
    private final ProcessStep child;
    private final Process parent;
    private IFaucet childFaucet;
    private List<ISink> childSinks;
    private boolean wasRemoved;

    public ProcessStepDeleteCommand(Process parent, ProcessStep child) {
        if (parent == null || child == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel(Messages.ProcessStepDeleteCommand_Label);
        this.parent = parent;
        this.child = child;
    }

    public boolean canUndo() {
        return this.wasRemoved;
    }

    public void execute() {
        ISink childAsSink;
        this.childFaucet = null;
        if (this.child instanceof ISink && (childAsSink = (ISink)((Object)this.child)).getFaucetConnection() != null) {
            this.childFaucet = childAsSink.getFaucetConnection().getFaucet();
        }
        this.childSinks = new ArrayList<ISink>();
        if (this.child instanceof IFaucet) {
            IFaucet childAsFaucet = (IFaucet)((Object)this.child);
            if (this.child instanceof SplitPipelineItem) {
                SplitPipelineItem splitChild = (SplitPipelineItem)this.child;
                for (Connection c : splitChild.getCopyOfSinkConnections()) {
                    this.childSinks.add(c.getSink());
                }
            } else if (childAsFaucet.getSinkConnection() != null) {
                this.childSinks.add(childAsFaucet.getSinkConnection().getSink());
            }
        }
        this.redo();
    }

    public void redo() {
        this.wasRemoved = this.parent.removeChild(this.child);
        if (this.wasRemoved) {
            if (this.childFaucet != null) {
                this.childFaucet.setSinkConnection(null);
            }
            if (this.child instanceof SplitPipelineItem) {
                ((SplitPipelineItem)this.child).removeAllSinks();
            }
            if (this.child instanceof SplitTemplate) {
                ((SplitTemplate)this.child).removeAllSinks();
            }
            for (ISink childSink : this.childSinks) {
                childSink.setFaucetConnection(null);
            }
        }
    }

    public void undo() {
        this.parent.add(this.child);
        if (this.child instanceof ISink && this.childFaucet != null) {
            Connection c = new Connection();
            c.connect(this.childFaucet, (ISink)((Object)this.child));
        }
        if (this.child instanceof IFaucet) {
            for (ISink childSink : this.childSinks) {
                Connection c = new Connection();
                c.connect((IFaucet)((Object)this.child), childSink);
            }
        }
    }
}

