/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.editor.command;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.model.ProcessStep;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class ProcessStepSetConstraintCommand
extends Command {
    private final Rectangle newBounds;
    private Rectangle oldBounds;
    private final ChangeBoundsRequest request;
    private final ProcessStep step;

    public ProcessStepSetConstraintCommand(ProcessStep step, ChangeBoundsRequest req, Rectangle newBounds) {
        if (step == null || req == null || newBounds == null) {
            throw new IllegalArgumentException();
        }
        this.step = step;
        this.request = req;
        this.newBounds = newBounds.getCopy();
        this.setLabel(Messages.ProcessStepSetConstraintCommand_Label);
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        return "move".equals(type) || "move children".equals(type) || "resize".equals(type) || "resize children".equals(type);
    }

    public void execute() {
        this.oldBounds = new Rectangle(this.step.getLocation(), this.step.getSize());
        this.redo();
    }

    public void redo() {
        this.step.setSize(this.newBounds.getSize());
        this.step.setLocation(this.newBounds.getLocation());
    }

    public void undo() {
        this.step.setSize(this.oldBounds.getSize());
        this.step.setLocation(this.oldBounds.getLocation());
    }
}

