/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.editor.parts;

import com.koutra.dist.proc.designer.editor.command.ProcessStepCreateCommand;
import com.koutra.dist.proc.designer.editor.command.ProcessStepSetConstraintCommand;
import com.koutra.dist.proc.designer.model.ModelElement;
import com.koutra.dist.proc.designer.model.Process;
import com.koutra.dist.proc.designer.model.ProcessStep;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class ProcessEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    public ProcessEditPart(Process process) {
        this.setModel(process);
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer();
        f.setBorder((Border)new MarginBorder(3));
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter((ConnectionRouter)new ShortestPathConnectionRouter((IFigure)f));
        return f;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ProcessXYLayoutEditPolicy());
    }

    protected List getModelChildren() {
        return ((Process)this.getModel()).getChildren();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("Process.StepAdded".equals(prop) || "Process.StepRemoved".equals(prop)) {
            this.refreshChildren();
        }
    }

    private static class ProcessXYLayoutEditPolicy
    extends XYLayoutEditPolicy {
        private ProcessXYLayoutEditPolicy() {
        }

        protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
            if (child instanceof EditPart && constraint instanceof Rectangle) {
                return new ProcessStepSetConstraintCommand((ProcessStep)child.getModel(), request, (Rectangle)constraint);
            }
            return super.createChangeConstraintCommand(request, child, constraint);
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            return null;
        }

        protected Command getCreateCommand(CreateRequest request) {
            Object child = request.getNewObject();
            if (child instanceof ProcessStep) {
                return new ProcessStepCreateCommand((ProcessStep)child, (Process)this.getHost().getModel(), (Rectangle)this.getConstraintFor(request));
            }
            return null;
        }
    }
}

