/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.editor.parts;

import com.koutra.dist.proc.designer.editor.command.ConnectionCreateCommand;
import com.koutra.dist.proc.designer.editor.command.ConnectionReconnectCommand;
import com.koutra.dist.proc.designer.editor.parts.ProcessComponentEditPolicy;
import com.koutra.dist.proc.designer.model.Connection;
import com.koutra.dist.proc.designer.model.ContentType;
import com.koutra.dist.proc.designer.model.Faucet;
import com.koutra.dist.proc.designer.model.IDemuxFaucet;
import com.koutra.dist.proc.designer.model.IFaucet;
import com.koutra.dist.proc.designer.model.IMuxSink;
import com.koutra.dist.proc.designer.model.ISink;
import com.koutra.dist.proc.designer.model.ModelElement;
import com.koutra.dist.proc.designer.model.PipelineItem;
import com.koutra.dist.proc.designer.model.ProcessStep;
import com.koutra.dist.proc.designer.model.Sink;
import com.koutra.dist.proc.designer.model.SplitPipelineItem;
import com.koutra.dist.proc.designer.model.Template;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public abstract class ProcessStepEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart {
    private ConnectionAnchor anchor = null;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    protected ProcessStep getCastedModel() {
        return (ProcessStep)this.getModel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ProcessComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new GraphicalNodeEditPolicy(){

            protected boolean canConnect(Object source, Object target) {
                boolean isTargetNormal;
                if (source == target) {
                    return false;
                }
                boolean isSourceDemux = source instanceof IDemuxFaucet;
                boolean isTargetMux = target instanceof IMuxSink;
                boolean isSourceNormal = source instanceof SplitPipelineItem || source instanceof PipelineItem || source instanceof Faucet;
                boolean bl = isTargetNormal = target instanceof SplitPipelineItem || target instanceof PipelineItem || target instanceof Sink;
                if (isSourceDemux && isTargetNormal && target instanceof Sink && !isTargetMux) {
                    return false;
                }
                if (isTargetMux && !isSourceNormal && source instanceof Faucet && !isSourceDemux) {
                    return false;
                }
                return !(isSourceNormal && !isTargetNormal && !isSourceDemux || isSourceNormal && isTargetNormal && isSourceDemux || !isSourceNormal && isTargetNormal && !isTargetMux) && (!isSourceNormal || !isTargetNormal || !isTargetMux);
            }

            protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
                if (!(this.getHost().getModel() instanceof ISink)) {
                    return null;
                }
                ISink sink = (ISink)this.getHost().getModel();
                if (sink.getFaucetConnection() != null && sink.getFaucetConnection().isConnected()) {
                    return null;
                }
                ConnectionCreateCommand cmd = (ConnectionCreateCommand)request.getStartCommand();
                ContentType[] contentTypeArray = ContentType.values();
                int n = contentTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentType contentType = contentTypeArray[n2];
                    if (cmd.getSource().supportsOutput(contentType) && !sink.supportsInput(contentType)) {
                        return null;
                    }
                    ++n2;
                }
                if (!this.canConnect(cmd.getSource(), sink)) {
                    return null;
                }
                cmd.setTarget(sink);
                return cmd;
            }

            protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
                ProcessStep source = (ProcessStep)this.getHost().getModel();
                if (!(source instanceof IFaucet)) {
                    return null;
                }
                IFaucet faucet = (IFaucet)((Object)source);
                if (!(faucet instanceof SplitPipelineItem) && faucet.getSinkConnection() != null && faucet.getSinkConnection().isConnected()) {
                    return null;
                }
                ConnectionCreateCommand cmd = new ConnectionCreateCommand(faucet);
                request.setStartCommand((Command)cmd);
                return cmd;
            }

            protected Command getReconnectSourceCommand(ReconnectRequest request) {
                ProcessStep newSource = (ProcessStep)this.getHost().getModel();
                if (!(newSource instanceof IFaucet)) {
                    return null;
                }
                IFaucet faucet = (IFaucet)((Object)newSource);
                if (!(faucet instanceof SplitPipelineItem) && faucet.getSinkConnection() != null && faucet.getSinkConnection().isConnected()) {
                    return null;
                }
                Connection conn = (Connection)request.getConnectionEditPart().getModel();
                ConnectionReconnectCommand cmd = new ConnectionReconnectCommand(conn);
                ContentType[] contentTypeArray = ContentType.values();
                int n = contentTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentType contentType = contentTypeArray[n2];
                    if (faucet.supportsOutput(contentType) && !cmd.getOldTarget().supportsInput(contentType)) {
                        return null;
                    }
                    ++n2;
                }
                if (!this.canConnect(faucet, cmd.getOldTarget())) {
                    return null;
                }
                cmd.setNewSource(faucet);
                return cmd;
            }

            protected Command getReconnectTargetCommand(ReconnectRequest request) {
                ProcessStep newTarget = (ProcessStep)this.getHost().getModel();
                if (!(newTarget instanceof ISink)) {
                    return null;
                }
                ISink sink = (ISink)((Object)newTarget);
                if (sink.getFaucetConnection() != null && sink.getFaucetConnection().isConnected()) {
                    return null;
                }
                Connection conn = (Connection)request.getConnectionEditPart().getModel();
                ConnectionReconnectCommand cmd = new ConnectionReconnectCommand(conn);
                ContentType[] contentTypeArray = ContentType.values();
                int n = contentTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentType contentType = contentTypeArray[n2];
                    if (cmd.getOldSource().supportsOutput(contentType) && !sink.supportsInput(contentType)) {
                        return null;
                    }
                    ++n2;
                }
                if (!this.canConnect(cmd.getOldSource(), sink)) {
                    return null;
                }
                cmd.setNewTarget(sink);
                return cmd;
            }
        });
    }

    protected IFigure createFigure() {
        IFigure f = this.createFigureForModel();
        f.setOpaque(true);
        ModelElement modelElement = (ModelElement)this.getModel();
        if (modelElement instanceof Faucet) {
            f.setBackgroundColor(ColorConstants.green);
        } else if (modelElement instanceof Template) {
            f.setBackgroundColor(ColorConstants.orange);
        } else if (modelElement instanceof PipelineItem) {
            f.setBackgroundColor(ColorConstants.blue);
        } else if (modelElement instanceof Sink) {
            f.setBackgroundColor(ColorConstants.red);
        }
        return f;
    }

    private IFigure createFigureForModel() {
        ModelElement modelElement = (ModelElement)this.getModel();
        ImageFigure retVal = new ImageFigure(modelElement.getLargeIcon());
        return retVal;
    }

    protected ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            if (this.getModel() instanceof ProcessStep) {
                this.anchor = new ChopboxAnchor(this.getFigure());
            } else {
                throw new IllegalArgumentException("unexpected model");
            }
        }
        return this.anchor;
    }

    protected List getModelSourceConnections() {
        Object model = this.getModel();
        if (model instanceof IFaucet && ((IFaucet)model).getSinkConnection() != null) {
            return Collections.singletonList(((IFaucet)model).getSinkConnection());
        }
        return Collections.EMPTY_LIST;
    }

    protected List getModelTargetConnections() {
        Object model = this.getModel();
        if (model instanceof ISink && ((ISink)model).getFaucetConnection() != null) {
            return Collections.singletonList(((ISink)model).getFaucetConnection());
        }
        return Collections.EMPTY_LIST;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("ProcessStep.Size".equals(prop) || "ProcessStep.Location".equals(prop)) {
            this.refreshVisuals();
        }
        if ("Faucet.Sink".equals(prop)) {
            this.refreshSourceConnections();
        }
        if ("Sink.Faucet".equals(prop)) {
            this.refreshTargetConnections();
        }
        if ("PipelineItem.Sink".equals(prop)) {
            this.refreshSourceConnections();
        }
        if ("PipelineItem.Faucet".equals(prop)) {
            this.refreshTargetConnections();
        }
    }

    protected void refreshVisuals() {
        Rectangle bounds = new Rectangle(this.getCastedModel().getLocation(), new Dimension(50, 50));
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
    }
}

