/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.launching;

import com.koutra.dist.proc.designer.model.Process;
import com.koutra.dist.proc.model.XformationException;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaLaunchDelegate;

public class KoutraXformLaunchConfigurationDelegate
extends JavaLaunchDelegate {
    protected ILaunch launch;
    protected String path;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.path = File.createTempFile("dist", ".proc").getAbsolutePath();
            String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            if (projectName == null) {
                throw new XformationException("No project has been specified");
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            String processFilePath = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            if (processFilePath == null) {
                throw new XformationException("No process file has been specified");
            }
            IFile processFile = project.getFile(Path.fromPortableString((String)processFilePath));
            Process process = Process.hydrate(processFile);
            process.saveExecutionSetUpToStream(this.path);
            this.launch = launch;
            super.launch(configuration, mode, launch, monitor);
        }
        catch (IOException ioe) {
            throw new XformationException("Unable to create process serialization file", (Throwable)ioe);
        }
        catch (CoreException e) {
            throw e;
        }
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        return String.valueOf(this.path) + " " + super.getProgramArguments(configuration);
    }

    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return "com.koutra.dist.proc.ProcessExecutor";
    }
}

