/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.launching;

import com.koutra.dist.proc.designer.KoutraXformImages;
import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.launching.ProcFileSelectionDialog;
import com.koutra.dist.proc.designer.model.Process;
import com.koutra.dist.proc.designer.utils.DesignerLog;
import com.koutra.dist.proc.designer.utils.SWTHelper;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class KoutraXformParametersTab
extends JavaLaunchTab {
    protected Text koutraXformText;
    private Button searchButton;
    protected static final String EMPTY_STRING = "";
    protected Text fProjText;
    private Button fProjButton;
    private WidgetListener fListener = new WidgetListener();

    public void createControl(Composite parent) {
        Composite comp = SWTHelper.createComposite(parent, parent.getFont(), 1, 1, 1808);
        ((GridLayout)comp.getLayout()).verticalSpacing = 0;
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.createMainTypeEditor(comp, Messages.KoutraXformParametersTab_KoutraXformLabel);
        this.setControl((Control)comp);
    }

    public Image getImage() {
        return KoutraXformImages.processImage;
    }

    public String getName() {
        return Messages.KoutraXformParametersTab_TabName;
    }

    public String getId() {
        return "org.eclipse.dist.proc.designer.koutraXformMainTab";
    }

    protected void handleSearchButtonSelected() {
        IJavaProject project = this.getJavaProject();
        IJavaProject[] elements = null;
        if (project == null || !project.exists()) {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            if (model != null) {
                try {
                    elements = model.getJavaProjects();
                }
                catch (JavaModelException e) {
                    DesignerLog.logError(e);
                }
            }
        } else {
            elements = new IJavaProject[]{project};
        }
        if (elements == null) {
            elements = new IJavaProject[]{};
        }
        IFile[] files = null;
        try {
            files = this.searchKoutraXforms((IRunnableContext)this.getLaunchConfigurationDialog(), elements);
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        ProcFileSelectionDialog dialog = new ProcFileSelectionDialog(this.getShell(), files, Messages.KoutraXformParametersTab_ProcSelectionDialogTitle);
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        IFile file = (IFile)results[0];
        if (file != null) {
            this.koutraXformText.setText(file.getProjectRelativePath().toPortableString());
            this.fProjText.setText(file.getProject().getName());
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateMainTypeFromConfig(config);
        this.updateProjectFromConfig(config);
    }

    private boolean hasKoutraXformRunType(IJavaProject javaProject) {
        try {
            return javaProject != null && javaProject.findType("com.koutra.dist.proc.ProcessExecutor") != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private boolean validateJavaProject(IJavaProject javaProject) {
        if (!this.hasKoutraXformRunType(javaProject)) {
            this.setErrorMessage(Messages.KoutraXformParametersTab_NoProcessExecutorInPathError);
            return false;
        }
        return true;
    }

    private boolean validateTestLoaderJVM(ILaunchConfiguration config) {
        if (config == null) {
            return true;
        }
        try {
            String compliance;
            IVMInstall vm;
            String path = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
            if (path != null && (vm = JavaRuntime.getVMInstall((IPath)Path.fromPortableString((String)path))) instanceof AbstractVMInstall && (compliance = ((AbstractVMInstall)vm).getJavaVersion()) != null && compliance.compareTo("1.6") < 0) {
                this.setErrorMessage(Messages.KoutraXformParametersTab_JDKVersionError);
                return false;
            }
        }
        catch (CoreException coreException) {}
        return true;
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(name, 4);
            if (status.isOK()) {
                String procName;
                IProject project;
                block14: {
                    block13: {
                        project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        if (!project.exists()) {
                            this.setErrorMessage(MessageFormat.format(Messages.KoutraXformParametersTab_NoProjectError, name));
                            return false;
                        }
                        if (!project.isOpen()) {
                            this.setErrorMessage(MessageFormat.format(Messages.KoutraXformParametersTab_ClosedProjectError, name));
                            return false;
                        }
                        IJavaProject javaProject = JavaCore.create((IProject)project);
                        if (!this.validateJavaProject(javaProject)) {
                            return false;
                        }
                        if (project.hasNature("org.eclipse.jdt.core.javanature")) break block13;
                        this.setErrorMessage(Messages.KoutraXformParametersTab_NotAJavaProjectError);
                        return false;
                    }
                    procName = this.koutraXformText.getText().trim();
                    if (procName.length() != 0) break block14;
                    this.setErrorMessage(Messages.KoutraXformParametersTab_NoKoutraXformError);
                    return false;
                }
                try {
                    if (project.findMember(procName) == null) {
                        this.setErrorMessage(MessageFormat.format(Messages.KoutraXformParametersTab_UnableToFindFileError, procName, name));
                        return false;
                    }
                }
                catch (CoreException e) {
                    DesignerLog.logError(e);
                }
                if (!this.validateTestLoaderJVM(config)) {
                    return false;
                }
            } else {
                this.setErrorMessage(MessageFormat.format(Messages.KoutraXformParametersTab_IllegalProjectNameError, status.getMessage()));
                return false;
            }
        }
        if ((name = this.koutraXformText.getText().trim()).length() == 0) {
            this.setErrorMessage(Messages.KoutraXformParametersTab_NoKoutraXformError2);
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText().trim());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.koutraXformText.getText().trim());
        this.mapResources(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        this.initializeMainTypeAndName(javaElement, config);
    }

    protected void createMainTypeEditor(Composite parent, String text) {
        Font font = parent.getFont();
        Group mainGroup = SWTHelper.createGroup(parent, text, 2, 1, 768);
        Composite comp = SWTHelper.createComposite((Composite)mainGroup, font, 2, 2, 1808, 0, 0);
        this.koutraXformText = SWTHelper.createSingleText(comp, 1);
        this.koutraXformText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KoutraXformParametersTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.searchButton = this.createPushButton(comp, Messages.KoutraXformParametersTab_SearchButtonText, null);
        this.searchButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                KoutraXformParametersTab.this.handleSearchButtonSelected();
            }
        });
    }

    protected void initializeMainTypeAndName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = null;
        if (javaElement instanceof IMember) {
            IMember member = (IMember)javaElement;
            javaElement = member.isBinary() ? member.getClassFile() : member.getCompilationUnit();
        }
        if (name == null) {
            name = EMPTY_STRING;
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, name);
        if (name.length() > 0) {
            int index = name.lastIndexOf(46);
            if (index > 0) {
                name = name.substring(index + 1);
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
        }
    }

    protected void updateMainTypeFromConfig(ILaunchConfiguration config) {
        String procFileName = EMPTY_STRING;
        try {
            procFileName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            DesignerLog.logError(ce);
        }
        this.koutraXformText.setText(procFileName);
    }

    private IJavaProject chooseJavaProject() {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(Messages.KoutraXformParametersTab_ProjectSelectionDialogTitle);
        dialog.setMessage(Messages.KoutraXformParametersTab_ProjectSelectionDialogMessage);
        try {
            dialog.setElements((Object[])JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects());
        }
        catch (JavaModelException jme) {
            DesignerLog.logError(jme);
        }
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    protected void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(Messages.KoutraXformParametersTab_ProjectGroupText);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.fProjText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener((ModifyListener)this.fListener);
        this.fProjButton = this.createPushButton((Composite)group, Messages.KoutraXformParametersTab_BrowseButtonText, null);
        this.fProjButton.addSelectionListener((SelectionListener)this.fListener);
    }

    protected WidgetListener getDefaultListener() {
        return this.fListener;
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    protected IJavaProject getJavaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    private void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            this.setErrorMessage(ce.getStatus().getMessage());
        }
        this.fProjText.setText(projectName);
    }

    public static IResource getResource(ILaunchConfiguration candidate) throws CoreException {
        IProject resource = null;
        String pname = candidate.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        if (!EMPTY_STRING.equals(pname)) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pname);
            String tname = candidate.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, EMPTY_STRING);
            if (!EMPTY_STRING.equals(tname)) {
                IType type;
                IJavaProject jproject;
                if (project != null && project.exists() && project.isOpen() && (jproject = JavaCore.create((IProject)project)) != null && jproject.exists() && (type = jproject.findType(tname = tname.replace('$', '.'))) != null && (resource = type.getUnderlyingResource()) == null) {
                    resource = (IResource)type.getAdapter(IResource.class);
                }
            } else {
                return project;
            }
            if (resource == null) {
                resource = project;
            }
        }
        return resource;
    }

    protected void mapResources(ILaunchConfigurationWorkingCopy config) {
        try {
            IJavaProject javaProject = this.getJavaProject();
            if (javaProject != null && javaProject.exists() && javaProject.isOpen()) {
                IResource resource = KoutraXformParametersTab.getResource((ILaunchConfiguration)config);
                IResource[] resources = null;
                if (resource != null) {
                    resources = new IResource[]{resource};
                }
                config.setMappedResources(resources);
            }
        }
        catch (CoreException ce) {
            this.setErrorMessage(ce.getStatus().getMessage());
        }
    }

    protected void recurseForContainer(IContainer container, List<IFile> result) throws CoreException {
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile f;
            IResource resource = iResourceArray[n2];
            if (resource instanceof IContainer) {
                this.recurseForContainer((IContainer)resource, result);
            } else if (resource instanceof IFile && "proc".equals((f = (IFile)resource).getFileExtension())) {
                try {
                    Process p = Process.hydrate(f);
                    if (p.validate().size() == 0) {
                        result.add(f);
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    protected IFile[] searchKoutraXforms(IProgressMonitor pm, IJavaProject[] projects) {
        pm.beginTask(Messages.KoutraXformParametersTab_SearchTaskTitle, 100);
        ArrayList<IFile> retVal = new ArrayList<IFile>();
        SubProgressMonitor monitor = new SubProgressMonitor(pm, 100);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (projects == null) {
                IFile[] iFileArray = new IFile[]{};
                return iFileArray;
            }
            int length = projects.length;
            if (monitor != null) {
                monitor.beginTask(Messages.KoutraXformParametersTab_SearchSubTaskTitle, 100 * length);
            }
            int i = 0;
            while (i < length) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IJavaProject project = projects[i];
                IProject p = project.getProject();
                try {
                    this.recurseForContainer((IContainer)p, retVal);
                }
                catch (CoreException e) {
                    DesignerLog.logError(e);
                }
                if (monitor != null) {
                    monitor.worked(100);
                }
                ++i;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return retVal.toArray(new IFile[retVal.size()]);
    }

    protected IFile[] searchKoutraXforms(IRunnableContext context, final IJavaProject[] projects) throws InvocationTargetException, InterruptedException {
        final IFile[][] res = new IFile[1][];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                res[0] = KoutraXformParametersTab.this.searchKoutraXforms(pm, projects);
            }
        };
        context.run(false, true, runnable);
        return res[0];
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            KoutraXformParametersTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == KoutraXformParametersTab.this.fProjButton) {
                KoutraXformParametersTab.this.handleProjectButtonSelected();
            } else {
                KoutraXformParametersTab.this.updateLaunchConfigurationDialog();
            }
        }
    }
}

