/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.launching;

import com.koutra.dist.proc.designer.KoutraXformPlugin;
import com.koutra.dist.proc.designer.Messages;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ProcFileSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String SETTINGS_ID = "com.koutra.dist.proc.designer.KOUTRAXFORM_SELECTION_DIALOG";
    private IFile[] files = null;

    public ProcFileSelectionDialog(Shell shell, IFile[] elements, String title) {
        super(shell, false);
        this.setTitle(title);
        this.files = elements;
        this.setMessage(Messages.ProcFileSelectionDialog_FileSelectionDialogDescription);
        this.setInitialPattern(Messages.ProcFileSelectionDialog_FileSelectionDialogInitialPattern);
        this.setListLabelProvider(new ProcFileLabelProvider());
        this.setDetailsLabelProvider(new ProcFileDetailsLabelProvider());
        this.setSelectionHistory(new ProcFileSelectionHistory());
    }

    protected Control createDialogArea(Composite parent) {
        Control ctrl = super.createDialogArea(parent);
        return ctrl;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = KoutraXformPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_ID);
        if (section == null) {
            section = settings.addNewSection(SETTINGS_ID);
        }
        return section;
    }

    protected Comparator<IFile> getItemsComparator() {
        Comparator<IFile> comp = new Comparator<IFile>(){

            @Override
            public int compare(IFile f1, IFile f2) {
                return f1.getName().compareTo(f2.getName());
            }
        };
        return comp;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ProcFileItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (this.files != null && this.files.length > 0) {
            int i = 0;
            while (i < this.files.length) {
                if (itemsFilter.isConsistentItem((Object)this.files[i])) {
                    contentProvider.add((Object)this.files[i], itemsFilter);
                }
                ++i;
            }
        }
    }

    public String getElementName(Object item) {
        if (item instanceof IFile) {
            return ((IFile)item).getName();
        }
        return null;
    }

    class ProcFileDetailsLabelProvider
    extends ProcFileLabelProvider {
        ProcFileDetailsLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (element instanceof IFile) {
                IFile f = (IFile)element;
                return this.getDeclaringContainerName(f);
            }
            return null;
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof IFile) {
                return super.getImage(this.getDeclaringContainer((IFile)element));
            }
            return super.getImage(element);
        }
    }

    class ProcFileItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        ProcFileItemsFilter() {
            super((FilteredItemsSelectionDialog)ProcFileSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof IFile;
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof IFile) || !Arrays.asList(ProcFileSelectionDialog.this.files).contains(item)) {
                return false;
            }
            return this.matches(((IFile)item).getName());
        }
    }

    public class ProcFileLabelProvider
    implements ILabelProvider {
        HashMap<ImageDescriptor, Image> imageMap = new HashMap();

        public Image getImage(Object element) {
            IWorkbenchAdapter adapter;
            if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
                ImageDescriptor descriptor = adapter.getImageDescriptor(element);
                Image image = this.imageMap.get(descriptor);
                if (image == null) {
                    image = descriptor.createImage();
                    this.imageMap.put(descriptor, image);
                }
                return image;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IFile) {
                IFile f = (IFile)element;
                String label = f.getName();
                String container = this.getDeclaringContainerName(f);
                if (container != null && !"".equals(container)) {
                    label = String.valueOf(label) + " - " + container;
                }
                return label;
            }
            return null;
        }

        protected String getDeclaringContainerName(IFile f) {
            return f.getParent().getFullPath().toString();
        }

        protected IContainer getDeclaringContainer(IFile f) {
            return f.getParent();
        }

        public void dispose() {
            this.imageMap.clear();
            this.imageMap = null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ProcFileSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        ProcFileSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            IPath p = Path.fromPortableString((String)memento.getTextData());
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(p);
            return f != null && f.exists() ? f : null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
            if (item instanceof IFile) {
                memento.putTextData(((IFile)item).getFullPath().toPortableString());
            }
        }
    }
}

