/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model;

import com.koutra.dist.proc.designer.model.IFaucet;
import com.koutra.dist.proc.designer.model.ISink;
import com.koutra.dist.proc.designer.model.ModelElement;
import com.koutra.dist.proc.designer.model.ValidationError;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class Connection
extends ModelElement {
    private static final Image IMAGE_ICON = Connection.createImage("icons/connection_s16.gif");
    private static final Image IMAGE_LARGE_ICON = Connection.createImage("icons/connection_s24.gif");
    protected IFaucet faucet = null;
    protected ISink sink = null;

    public void connect(IFaucet faucet, ISink sink) {
        if (this.faucet == faucet && this.sink == sink) {
            return;
        }
        this.faucet = faucet;
        this.sink = sink;
        this.faucet.setSinkConnection(this);
        this.sink.setFaucetConnection(this);
    }

    public void disconnect() {
        this.faucet.setSinkConnection(null);
        this.sink.setFaucetConnection(null);
        this.faucet = null;
        this.sink = null;
    }

    public boolean isConnected() {
        return this.faucet != null && this.sink != null;
    }

    public IFaucet getFaucet() {
        return this.faucet;
    }

    public ISink getSink() {
        return this.sink;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)obj;
        return this.faucet == other.faucet && this.sink == other.sink;
    }

    @Override
    public ModelElement deepCopy() {
        Connection retVal = new Connection();
        if (this.sink != null) {
            retVal.sink = (ISink)((Object)((ModelElement)((Object)this.sink)).deepCopy());
        }
        return retVal;
    }

    @Override
    public Image getIcon() {
        return IMAGE_ICON;
    }

    @Override
    public Image getLargeIcon() {
        return IMAGE_LARGE_ICON;
    }

    @Override
    public void setUpExecution() {
    }

    @Override
    public Object getExecutionRepresentation() {
        return null;
    }

    @Override
    public void dehydrate(IMemento memento) {
    }

    @Override
    public void hydrate(IMemento memento) {
    }

    @Override
    public List<ValidationError> validate() {
        return Collections.emptyList();
    }
}

