/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model;

import com.koutra.dist.proc.designer.model.Connection;
import com.koutra.dist.proc.designer.model.IFaucet;
import com.koutra.dist.proc.designer.model.ISink;
import com.koutra.dist.proc.designer.model.ProcessStep;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public abstract class Faucet
extends ProcessStep
implements IFaucet {
    private static final Image IMAGE_ICON = Faucet.createImage("icons/go-next.png");
    private static final Image IMAGE_LARGE_ICON = Faucet.createImage("icons/go-next_large.png");
    public static final String SINK_PROP = "Faucet.Sink";
    protected Connection connection = null;
    protected ISink oldValue = null;
    private String sinkId;

    @Override
    public Image getIcon() {
        return IMAGE_ICON;
    }

    @Override
    public Image getLargeIcon() {
        return IMAGE_LARGE_ICON;
    }

    @Override
    public Connection getSinkConnection() {
        return this.connection;
    }

    @Override
    public void setSinkConnection(Connection connection) {
        if (connection == null) {
            this.setPropertyValue(SINK_PROP, null);
        } else if (this.connection == null || this.connection.getSink() != connection.getSink()) {
            this.oldValue = this.connection == null ? null : this.connection.getSink();
            try {
                this.connection = connection;
                this.setPropertyValue(SINK_PROP, connection.getSink());
            }
            finally {
                this.oldValue = null;
            }
        }
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (SINK_PROP.equals(propertyId)) {
            return this.connection == null ? null : this.connection.getSink();
        }
        return super.getPropertyValue(propertyId);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (SINK_PROP.equals(propertyId)) {
            if (value == null) {
                this.connection = null;
            } else {
                if (this.connection == null) {
                    this.connection = new Connection();
                }
                this.connection.connect(this, (ISink)value);
            }
            this.firePropertyChange(SINK_PROP, this.oldValue, value);
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    @Override
    public String getSinkId() {
        return this.sinkId;
    }

    @Override
    public void dehydrate(IMemento memento) {
        if (this.connection != null && this.connection.getSink() != null) {
            memento.putString("sinkId", ((ProcessStep)((Object)this.connection.getSink())).getId());
        }
        super.dehydrate(memento);
    }

    @Override
    public void hydrate(IMemento memento) {
        this.sinkId = memento.getString("sinkId");
        super.hydrate(memento);
    }
}

