/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model;

import com.koutra.dist.proc.designer.model.ValidationError;
import com.koutra.dist.proc.designer.utils.DesignerLog;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;

public abstract class ModelElement
implements IPropertySource2 {
    public static final String PARENT_PROP = "ModelElement.Parent";
    public static final String CHILD_MOVE_UP = "ModelElement.ChildMoveUp";
    public static final String CHILD_MOVE_DOWN = "ModelElement.ChildMoveDown";
    private static final IPropertyDescriptor[] EMPTY_ARRAY = new IPropertyDescriptor[0];
    private transient PropertyChangeSupport pcsDelegate = new PropertyChangeSupport(this);
    private ModelElement parent;

    public ModelElement() {
        this.setParent(null);
    }

    public void setParent(ModelElement parent) {
        this.setPropertyValue(PARENT_PROP, parent);
    }

    public ModelElement getParent() {
        return this.parent;
    }

    public abstract List<ValidationError> validate();

    public abstract void setUpExecution();

    public abstract Object getExecutionRepresentation();

    public abstract void hydrate(IMemento var1);

    public abstract void dehydrate(IMemento var1);

    public abstract ModelElement deepCopy();

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return EMPTY_ARRAY;
    }

    public Object getPropertyValue(Object id) {
        if (PARENT_PROP.equals(id)) {
            return this.getParent();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return PARENT_PROP.equals(id);
    }

    public void resetPropertyValue(Object id) {
        if (PARENT_PROP.equals(id)) {
            this.setParent(null);
        }
    }

    public boolean isPropertyResettable(Object id) {
        return PARENT_PROP.equals(id);
    }

    public void setPropertyValue(Object id, Object value) {
        if (PARENT_PROP.equals(id)) {
            ModelElement oldValue = this.parent;
            this.parent = (ModelElement)value;
            this.firePropertyChange(PARENT_PROP, oldValue, value);
        }
    }

    public abstract Image getIcon();

    public abstract Image getLargeIcon();

    protected static Image createImage(String name) {
        InputStream stream = ModelElement.class.getResourceAsStream(name);
        Image image = new Image(null, stream);
        try {
            stream.close();
        }
        catch (IOException ioe) {
            DesignerLog.logError("Unable to create image for: " + name, ioe);
        }
        return image;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.pcsDelegate.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (l != null) {
            this.pcsDelegate.removePropertyChangeListener(l);
        }
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (this.pcsDelegate.hasListeners(property)) {
            this.pcsDelegate.firePropertyChange(property, oldValue, newValue);
        }
    }
}

