/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.model.Connection;
import com.koutra.dist.proc.designer.model.Faucet;
import com.koutra.dist.proc.designer.model.IFaucet;
import com.koutra.dist.proc.designer.model.ISink;
import com.koutra.dist.proc.designer.model.ISplitPipelineItem;
import com.koutra.dist.proc.designer.model.ModelElement;
import com.koutra.dist.proc.designer.model.PipelineItem;
import com.koutra.dist.proc.designer.model.ProcessStep;
import com.koutra.dist.proc.designer.model.Sink;
import com.koutra.dist.proc.designer.model.SplitPipelineItem;
import com.koutra.dist.proc.designer.model.ValidationError;
import com.koutra.dist.proc.designer.utils.DesignerLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.jgroups.util.Streamable;

public class Process
extends ModelElement {
    public static final String TAG_PROCESS = "process";
    public static final String TAG_ID = "id";
    public static final String TAG_STEPS = "steps";
    public static final String TAG_STEP = "step";
    public static final String TAG_TYPE = "type";
    private static final Image IMAGE_ICON = Process.createImage("icons/palette.png");
    private static final Image IMAGE_LARGE_ICON = Process.createImage("icons/palette_large.png");
    public static final String STEP_ADDED_PROP = "Process.StepAdded";
    public static final String STEP_REMOVED_PROP = "Process.StepRemoved";
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"Process.ID", Messages.Process_IDPropertyDescription)};
    public static final String ID_PROP = "Process.ID";
    protected List<ProcessStep> children;
    protected String id = UUID.randomUUID().toString();
    protected boolean hasBeenSetUp = false;

    static {
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getId().equals(ID_PROP)) {
                ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        return null;
                    }
                });
            }
            ++i;
        }
    }

    public Process() {
        this.children = new ArrayList<ProcessStep>();
    }

    public void add(ProcessStep child) {
        if (child != null && child instanceof ProcessStep && this.children.add(child)) {
            child.setParent(this);
            this.firePropertyChange(STEP_ADDED_PROP, null, child);
        }
    }

    @Override
    public ModelElement deepCopy() {
        Process retVal = new Process();
        for (ModelElement modelElement : this.children) {
            if (modelElement instanceof Faucet) {
                retVal.children.add((ProcessStep)modelElement.deepCopy());
                continue;
            }
            if (modelElement instanceof Sink && modelElement.getPropertyValue("Sink.Faucet") != null) {
                retVal.children.add((ProcessStep)modelElement.deepCopy());
                continue;
            }
            if (!(modelElement instanceof PipelineItem) || modelElement.getPropertyValue("PipelineItem.Faucet") == null) continue;
            retVal.children.add((ProcessStep)modelElement.deepCopy());
        }
        return retVal;
    }

    public List<ProcessStep> getChildren() {
        return this.children;
    }

    @Override
    public Image getIcon() {
        return IMAGE_ICON;
    }

    @Override
    public Image getLargeIcon() {
        return IMAGE_LARGE_ICON;
    }

    public boolean removeChild(ProcessStep child) {
        if (child != null && child instanceof ProcessStep && this.children.remove(child)) {
            child.setParent(null);
            this.firePropertyChange(STEP_REMOVED_PROP, null, child);
            return true;
        }
        return false;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> superList = new ArrayList<IPropertyDescriptor>(Arrays.asList(super.getPropertyDescriptors()));
        superList.addAll(Arrays.asList(descriptors));
        IPropertyDescriptor[] retVal = new IPropertyDescriptor[superList.size()];
        int counter = 0;
        for (IPropertyDescriptor pd : superList) {
            retVal[counter++] = pd;
        }
        return retVal;
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (ID_PROP.equals(propertyId)) {
            return this.id;
        }
        return super.getPropertyValue(propertyId);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (ID_PROP.equals(propertyId)) {
            String oldValue = this.id;
            this.id = (String)value;
            this.firePropertyChange(ID_PROP, oldValue, value);
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    @Override
    public void setUpExecution() {
        for (ModelElement modelElement : this.children) {
            if (!(modelElement instanceof Faucet)) continue;
            modelElement.setUpExecution();
        }
        this.hasBeenSetUp = true;
    }

    public void saveExecutionSetUpToStream(String path) throws IOException {
        this.setUpExecution();
        File f = new File(path);
        DataOutputStream out = new DataOutputStream(new FileOutputStream(f));
        for (ModelElement modelElement : this.children) {
            if (!(modelElement instanceof Faucet)) continue;
            Streamable streamable = (Streamable)modelElement.getExecutionRepresentation();
            out.writeUTF(streamable.getClass().getCanonicalName());
            streamable.writeTo(out);
        }
        out.close();
    }

    @Override
    public Object getExecutionRepresentation() {
        return null;
    }

    public void execute() {
        if (!this.hasBeenSetUp) {
            return;
        }
        try {
            com.koutra.dist.proc.model.ISink sink;
            for (ModelElement modelElement : this.children) {
                if (!(modelElement instanceof Sink)) continue;
                sink = (com.koutra.dist.proc.model.ISink)modelElement.getExecutionRepresentation();
                sink.consume();
            }
            for (ModelElement modelElement : this.children) {
                if (!(modelElement instanceof Sink)) continue;
                sink = (com.koutra.dist.proc.model.ISink)modelElement.getExecutionRepresentation();
                sink.dispose();
            }
        }
        finally {
            this.hasBeenSetUp = false;
        }
    }

    @Override
    public void dehydrate(IMemento memento) {
        memento.putString(TAG_ID, this.id);
        IMemento stepListMemento = memento.createChild(TAG_STEPS);
        for (ModelElement modelElement : this.children) {
            IMemento stepMemento = stepListMemento.createChild(TAG_STEP);
            stepMemento.putString(TAG_TYPE, modelElement.getClass().getName());
            modelElement.dehydrate(stepMemento);
        }
    }

    @Override
    public void hydrate(IMemento memento) {
        this.id = memento.getString(TAG_ID);
        this.children.clear();
        IMemento stepListMemento = memento.getChild(TAG_STEPS);
        if (stepListMemento == null) {
            return;
        }
        IMemento[] stepMementos = stepListMemento.getChildren(TAG_STEP);
        HashMap<String, ProcessStep> idMap = new HashMap<String, ProcessStep>();
        IMemento[] iMementoArray = stepMementos;
        int n = stepMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento stepMemento = iMementoArray[n2];
            String stepClassName = stepMemento.getString(TAG_TYPE);
            try {
                Class<?> stepClass = Class.forName(stepClassName);
                ProcessStep step = (ProcessStep)stepClass.newInstance();
                step.hydrate(stepMemento);
                this.children.add(step);
                idMap.put(step.getId(), step);
            }
            catch (Exception e) {
                DesignerLog.logError("Unable to hydrate process", e);
            }
            ++n2;
        }
        for (ProcessStep element : this.children) {
            ISink sink;
            Connection connection;
            if (element instanceof IFaucet) {
                if (element instanceof SplitPipelineItem) {
                    SplitPipelineItem splitItem = (SplitPipelineItem)element;
                    if (splitItem.getSinkIds() == null || splitItem.getSinkIds().size() == 0) continue;
                    for (String sinkId : splitItem.getSinkIds()) {
                        ISink sink2 = (ISink)idMap.get(sinkId);
                        if (sink2 == null) {
                            throw new IllegalStateException("Unable to find sink with ID: " + sinkId);
                        }
                        Connection connection2 = new Connection();
                        connection2.connect(splitItem, sink2);
                    }
                } else {
                    IFaucet faucet = (IFaucet)((Object)element);
                    if (faucet.getSinkId() == null) continue;
                    ISink sink3 = (ISink)idMap.get(faucet.getSinkId());
                    if (sink3 == null) {
                        throw new IllegalStateException("Unable to find sink with ID: " + faucet.getSinkId());
                    }
                    connection = new Connection();
                    connection.connect(faucet, sink3);
                }
            }
            if (!(element instanceof ISink) || (sink = (ISink)((Object)element)).getFaucetId() == null) continue;
            IFaucet faucet = (IFaucet)idMap.get(sink.getFaucetId());
            if (faucet == null) {
                throw new IllegalStateException("Unable to find faucet with ID: " + sink.getFaucetId());
            }
            connection = new Connection();
            connection.connect(faucet, sink);
        }
    }

    public static void dehydrate(IFile f, Process process, IProgressMonitor monitor) throws IOException, CoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(baos);
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_PROCESS);
        process.dehydrate((IMemento)memento);
        memento.save((Writer)writer);
        writer.close();
        if (f.exists()) {
            f.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), 2, monitor);
        } else {
            f.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), 2, monitor);
        }
    }

    public static Process hydrate(IFile f) throws IOException, CoreException {
        Process retVal = new Process();
        InputStreamReader reader = new InputStreamReader(f.getContents());
        XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
        retVal.hydrate((IMemento)memento);
        ((Reader)reader).close();
        return retVal;
    }

    @Override
    public List<ValidationError> validate() {
        ArrayList<ValidationError> retVal = new ArrayList<ValidationError>();
        for (ProcessStep step : this.children) {
            if (step instanceof ISink && (((ISink)((Object)step)).getFaucetConnection() == null || ((ISink)((Object)step)).getFaucetConnection().getFaucet() == null)) {
                DesignerLog.logInfo("Process step with ID: " + step.getId() + " does not have a hooked up faucet.");
                retVal.add(new ValidationError(step, Messages.Process_NoFaucetValidationMessage));
            }
            if (step instanceof IFaucet && !(step instanceof ISplitPipelineItem) && (((IFaucet)((Object)step)).getSinkConnection() == null || ((IFaucet)((Object)step)).getSinkConnection().getSink() == null)) {
                DesignerLog.logInfo("Process step with ID: " + step.getId() + " does not have a hooked up sink.");
                retVal.add(new ValidationError(step, Messages.Process_FaucetNoSinkValidationMessage));
            }
            if (step instanceof IFaucet && step instanceof ISplitPipelineItem && ((SplitPipelineItem)step).getSinkConnectionsSize() == 0) {
                DesignerLog.logInfo("Process step with ID: " + step.getId() + " does not have a hooked up sink.");
                retVal.add(new ValidationError(step, Messages.Process_SplitNoSinkValidationMessage));
            }
            retVal.addAll(step.validate());
        }
        return retVal;
    }
}

