/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.model.ModelElement;
import java.util.UUID;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public abstract class ProcessStep
extends ModelElement {
    public static final String TAG_ID = "id";
    public static final String TAG_X = "x";
    public static final String TAG_Y = "y";
    public static final String TAG_WIDTH = "width";
    public static final String TAG_HEIGHT = "height";
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"ProcessStep.xPos", Messages.ProcessStep_XPropertyDescription), new TextPropertyDescriptor((Object)"ProcessStep.yPos", Messages.ProcessStep_YPropertyDescription)};
    private static final String HEIGHT_PROP = "ProcessStep.Height";
    private static final String WIDTH_PROP = "ProcessStep.Width";
    private static final String XPOS_PROP = "ProcessStep.xPos";
    private static final String YPOS_PROP = "ProcessStep.yPos";
    public static final String LOCATION_PROP = "ProcessStep.Location";
    public static final String SIZE_PROP = "ProcessStep.Size";
    private String id = UUID.randomUUID().toString();
    private Point location = new Point(0, 0);
    private Dimension size = new Dimension(50, 50);

    static {
        int i = 0;
        while (i < descriptors.length) {
            ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    int intValue = -1;
                    try {
                        intValue = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return Messages.ProcessStep_NotANumberMessage;
                    }
                    return intValue >= 0 ? null : Messages.ProcessStep_NegativeValueMessage;
                }
            });
            ++i;
        }
    }

    public String getId() {
        return this.id;
    }

    public Point getLocation() {
        return this.location.getCopy();
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (XPOS_PROP.equals(propertyId)) {
            return Integer.toString(this.location.x);
        }
        if (YPOS_PROP.equals(propertyId)) {
            return Integer.toString(this.location.y);
        }
        if (HEIGHT_PROP.equals(propertyId)) {
            return Integer.toString(this.size.height);
        }
        if (WIDTH_PROP.equals(propertyId)) {
            return Integer.toString(this.size.width);
        }
        return super.getPropertyValue(propertyId);
    }

    public Dimension getSize() {
        return this.size.getCopy();
    }

    public void setLocation(Point newLocation) {
        if (newLocation == null) {
            throw new IllegalArgumentException();
        }
        this.location.setLocation(newLocation);
        this.firePropertyChange(LOCATION_PROP, null, this.location);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (XPOS_PROP.equals(propertyId)) {
            int x = Integer.parseInt((String)value);
            this.setLocation(new Point(x, this.location.y));
        } else if (YPOS_PROP.equals(propertyId)) {
            int y = Integer.parseInt((String)value);
            this.setLocation(new Point(this.location.x, y));
        } else if (HEIGHT_PROP.equals(propertyId)) {
            int height = Integer.parseInt((String)value);
            this.setSize(new Dimension(this.size.width, height));
        } else if (WIDTH_PROP.equals(propertyId)) {
            int width = Integer.parseInt((String)value);
            this.setSize(new Dimension(width, this.size.height));
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    public void setSize(Dimension newSize) {
        if (newSize != null) {
            this.size.setSize(newSize);
            this.firePropertyChange(SIZE_PROP, null, this.size);
        }
    }

    @Override
    public void dehydrate(IMemento memento) {
        memento.putString(TAG_ID, this.id);
        memento.putInteger(TAG_X, this.location.x);
        memento.putInteger(TAG_Y, this.location.y);
        memento.putInteger(TAG_WIDTH, this.size.width);
        memento.putInteger(TAG_HEIGHT, this.size.height);
    }

    @Override
    public void hydrate(IMemento memento) {
        this.id = memento.getString(TAG_ID);
        this.location.x = memento.getInteger(TAG_X);
        this.location.y = memento.getInteger(TAG_Y);
        this.size.width = memento.getInteger(TAG_WIDTH);
        this.size.height = memento.getInteger(TAG_HEIGHT);
    }
}

