/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model;

import com.koutra.dist.proc.designer.model.Connection;
import com.koutra.dist.proc.designer.model.IFaucet;
import com.koutra.dist.proc.designer.model.ISink;
import com.koutra.dist.proc.designer.model.ProcessStep;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public abstract class Sink
extends ProcessStep
implements ISink {
    private static final Image IMAGE_ICON = Sink.createImage("icons/document-save.png");
    private static final Image IMAGE_LARGE_ICON = Sink.createImage("icons/document-save_large.png");
    public static final String FAUCET_PROP = "Sink.Faucet";
    protected Connection connection = null;
    protected IFaucet oldValue = null;
    private String faucetId;

    @Override
    public Image getIcon() {
        return IMAGE_ICON;
    }

    @Override
    public Image getLargeIcon() {
        return IMAGE_LARGE_ICON;
    }

    @Override
    public Connection getFaucetConnection() {
        return this.connection;
    }

    @Override
    public void setFaucetConnection(Connection connection) {
        if (connection == null) {
            this.setPropertyValue(FAUCET_PROP, null);
        } else if (this.connection == null || this.connection.getFaucet() != connection.getFaucet()) {
            this.oldValue = this.connection == null ? null : this.connection.getFaucet();
            try {
                this.connection = connection;
                this.setPropertyValue(FAUCET_PROP, connection.getFaucet());
            }
            finally {
                this.oldValue = null;
            }
        }
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (FAUCET_PROP.equals(propertyId)) {
            return this.connection == null ? null : this.connection.getFaucet();
        }
        return super.getPropertyValue(propertyId);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (FAUCET_PROP.equals(propertyId)) {
            if (value == null) {
                this.connection = null;
            } else {
                if (this.connection == null) {
                    this.connection = new Connection();
                }
                this.connection.connect((IFaucet)value, this);
            }
            this.firePropertyChange(FAUCET_PROP, this.oldValue, value);
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    @Override
    public String getFaucetId() {
        return this.faucetId;
    }

    @Override
    public void dehydrate(IMemento memento) {
        if (this.connection != null && this.connection.getSink() != null) {
            memento.putString("faucetId", ((ProcessStep)((Object)this.connection.getFaucet())).getId());
        }
        super.dehydrate(memento);
    }

    @Override
    public void hydrate(IMemento memento) {
        this.faucetId = memento.getString("faucetId");
        super.hydrate(memento);
    }
}

