/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model;

import com.koutra.dist.proc.designer.model.Connection;
import com.koutra.dist.proc.designer.model.IFaucet;
import com.koutra.dist.proc.designer.model.ISplitPipelineItem;
import com.koutra.dist.proc.designer.model.ProcessStep;
import com.koutra.dist.proc.designer.model.SplitConnection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public abstract class SplitTemplate
extends ProcessStep
implements IFaucet,
ISplitPipelineItem {
    private static final String TAG_SINK_LIST = "sinkList";
    private static final String TAG_SINK_TAG = "sink";
    private static final Image IMAGE_ICON = SplitTemplate.createImage("icons/applications-system.png");
    private static final Image IMAGE_LARGE_ICON = SplitTemplate.createImage("icons/applications-system_large.png");
    public static final String FAUCET_PROP = "SplitTemplate.Faucet";
    public static final String SINK_ADDED_PROP = "SplitTemplate.SinkAdded";
    public static final String SINK_REMOVED_PROP = "SplitTemplate.SinkRemoved";
    protected Connection faucetConnection = null;
    protected List<SplitConnection> sinkConnections = new ArrayList<SplitConnection>();
    protected Object oldValue = null;
    private List<String> sinkIds = null;
    private String faucetId = null;

    @Override
    public Image getIcon() {
        return IMAGE_ICON;
    }

    @Override
    public Image getLargeIcon() {
        return IMAGE_LARGE_ICON;
    }

    @Override
    public Connection getFaucetConnection() {
        return this.faucetConnection;
    }

    @Override
    public void setFaucetConnection(Connection connection) {
        if (connection == null) {
            this.setPropertyValue(FAUCET_PROP, null);
        } else if (this.faucetConnection == null || this.faucetConnection.getFaucet() != connection.getFaucet()) {
            this.oldValue = this.faucetConnection == null ? null : this.faucetConnection.getFaucet();
            try {
                this.faucetConnection = connection;
                this.setPropertyValue(FAUCET_PROP, connection.getFaucet());
            }
            finally {
                this.oldValue = null;
            }
        }
    }

    @Override
    public Connection getSinkConnection() {
        throw new IllegalStateException("Calling the getSinkConnection() method of a SplitTemplate is not allowed. Connections are made through the SplitConnection class.");
    }

    @Override
    public void setSinkConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        if (connection instanceof SplitConnection) {
            for (SplitConnection c : this.sinkConnections) {
                if (c.getSink() != connection.sink) continue;
                return;
            }
            this.sinkConnections.add((SplitConnection)connection);
            this.updateSinkConnections();
            this.firePropertyChange(SINK_ADDED_PROP, null, connection);
        } else {
            SplitConnection splitConnection = new SplitConnection(this.sinkConnections.size());
            splitConnection.connect(connection.faucet, connection.sink);
        }
    }

    public List<Connection> getCopyOfSinkConnections() {
        ArrayList<Connection> retVal = new ArrayList<Connection>(this.sinkConnections);
        return retVal;
    }

    public int getSinkConnectionsSize() {
        return this.sinkConnections.size();
    }

    public void removeAllSinks() {
        this.sinkConnections.clear();
    }

    private void updateSinkConnections() {
        int i = 0;
        while (i < this.sinkConnections.size()) {
            SplitConnection c = this.sinkConnections.get(i);
            c.setIndex(i);
            ++i;
        }
    }

    public void removeSinkConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        if (this.sinkConnections.contains(connection)) {
            this.sinkConnections.remove(connection);
            this.updateSinkConnections();
            this.firePropertyChange(SINK_REMOVED_PROP, connection, null);
        }
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (FAUCET_PROP.equals(propertyId)) {
            return this.faucetConnection == null ? null : this.faucetConnection.getFaucet();
        }
        return super.getPropertyValue(propertyId);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (FAUCET_PROP.equals(propertyId)) {
            if (value == null) {
                this.faucetConnection = null;
            } else {
                if (this.faucetConnection == null) {
                    this.faucetConnection = new Connection();
                }
                this.faucetConnection.connect((IFaucet)value, this);
            }
            this.firePropertyChange(FAUCET_PROP, this.oldValue, value);
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    @Override
    public String getSinkId() {
        throw new IllegalStateException("Calling the getSinkId() method of a SplitPipelineItem is not allowed. Call getSinkIds() instead.");
    }

    public List<String> getSinkIds() {
        return this.sinkIds;
    }

    @Override
    public String getFaucetId() {
        return this.faucetId;
    }

    @Override
    public void dehydrate(IMemento memento) {
        IMemento sinkListMemento = memento.createChild(TAG_SINK_LIST);
        for (Connection connection : this.sinkConnections) {
            if (connection == null || connection.getSink() == null) continue;
            IMemento sinkMemento = sinkListMemento.createChild(TAG_SINK_TAG);
            sinkMemento.putString("sinkId", ((ProcessStep)((Object)connection.getSink())).getId());
        }
        if (this.faucetConnection != null && this.faucetConnection.getSink() != null) {
            memento.putString("faucetId", ((ProcessStep)((Object)this.faucetConnection.getFaucet())).getId());
        }
        super.dehydrate(memento);
    }

    @Override
    public void hydrate(IMemento memento) {
        this.sinkIds = new ArrayList<String>();
        IMemento sinkListMemento = memento.getChild(TAG_SINK_LIST);
        if (sinkListMemento != null) {
            IMemento[] sinkMementos;
            IMemento[] iMementoArray = sinkMementos = sinkListMemento.getChildren(TAG_SINK_TAG);
            int n = sinkMementos.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento sinkMemento = iMementoArray[n2];
                this.sinkIds.add(sinkMemento.getString("sinkId"));
                ++n2;
            }
        }
        this.faucetId = memento.getString("faucetId");
        super.hydrate(memento);
    }
}

