/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model;

import com.koutra.dist.proc.designer.model.Connection;
import com.koutra.dist.proc.designer.model.IFaucet;
import com.koutra.dist.proc.designer.model.IPipelineItem;
import com.koutra.dist.proc.designer.model.ISink;
import com.koutra.dist.proc.designer.model.ProcessStep;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public abstract class Template
extends ProcessStep
implements IPipelineItem {
    private static final Image IMAGE_ICON = Template.createImage("icons/applications-system.png");
    private static final Image IMAGE_LARGE_ICON = Template.createImage("icons/applications-system_large.png");
    public static final String FAUCET_PROP = "Template.Faucet";
    public static final String SINK_PROP = "Template.Sink";
    protected Connection faucetConnection = null;
    protected Connection sinkConnection = null;
    protected Object oldValue = null;
    private String sinkId = null;
    private String faucetId = null;

    @Override
    public Image getIcon() {
        return IMAGE_ICON;
    }

    @Override
    public Image getLargeIcon() {
        return IMAGE_LARGE_ICON;
    }

    @Override
    public Connection getFaucetConnection() {
        return this.faucetConnection;
    }

    @Override
    public void setFaucetConnection(Connection connection) {
        if (connection == null) {
            this.setPropertyValue(FAUCET_PROP, null);
        } else if (this.faucetConnection == null || this.faucetConnection.getFaucet() != connection.getFaucet()) {
            this.oldValue = this.faucetConnection == null ? null : this.faucetConnection.getFaucet();
            try {
                this.faucetConnection = connection;
                this.setPropertyValue(FAUCET_PROP, connection.getFaucet());
            }
            finally {
                this.oldValue = null;
            }
        }
    }

    @Override
    public Connection getSinkConnection() {
        return this.sinkConnection;
    }

    @Override
    public void setSinkConnection(Connection connection) {
        if (connection == null) {
            this.setPropertyValue(SINK_PROP, null);
        } else if (this.sinkConnection == null || this.sinkConnection.getSink() != connection.getSink()) {
            this.oldValue = this.sinkConnection == null ? null : this.sinkConnection.getSink();
            try {
                this.sinkConnection = connection;
                this.setPropertyValue(SINK_PROP, connection.getSink());
            }
            finally {
                this.oldValue = null;
            }
        }
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (SINK_PROP.equals(propertyId)) {
            return this.sinkConnection == null ? null : this.sinkConnection.getSink();
        }
        if (FAUCET_PROP.equals(propertyId)) {
            return this.faucetConnection == null ? null : this.faucetConnection.getFaucet();
        }
        return super.getPropertyValue(propertyId);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (SINK_PROP.equals(propertyId)) {
            if (value == null) {
                this.sinkConnection = null;
            } else {
                if (this.sinkConnection == null) {
                    this.sinkConnection = new Connection();
                }
                this.sinkConnection.connect(this, (ISink)value);
            }
            this.firePropertyChange(SINK_PROP, this.oldValue, value);
        } else if (FAUCET_PROP.equals(propertyId)) {
            if (value == null) {
                this.faucetConnection = null;
            } else {
                if (this.faucetConnection == null) {
                    this.faucetConnection = new Connection();
                }
                this.faucetConnection.connect((IFaucet)value, this);
            }
            this.firePropertyChange(FAUCET_PROP, this.oldValue, value);
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    @Override
    public String getSinkId() {
        return this.sinkId;
    }

    @Override
    public String getFaucetId() {
        return this.faucetId;
    }

    @Override
    public void dehydrate(IMemento memento) {
        if (this.sinkConnection != null && this.sinkConnection.getSink() != null) {
            memento.putString("sinkId", ((ProcessStep)((Object)this.sinkConnection.getSink())).getId());
        }
        if (this.faucetConnection != null && this.faucetConnection.getSink() != null) {
            memento.putString("faucetId", ((ProcessStep)((Object)this.faucetConnection.getFaucet())).getId());
        }
        super.dehydrate(memento);
    }

    @Override
    public void hydrate(IMemento memento) {
        this.sinkId = memento.getString("sinkId");
        this.faucetId = memento.getString("faucetId");
        super.hydrate(memento);
    }
}

