/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model.faucet;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.model.Connection;
import com.koutra.dist.proc.designer.model.ContentType;
import com.koutra.dist.proc.designer.model.Faucet;
import com.koutra.dist.proc.designer.model.ModelElement;
import com.koutra.dist.proc.designer.model.ValidationError;
import com.koutra.dist.proc.designer.properties.FileChooserPropertyDescriptor;
import com.koutra.dist.proc.model.ISink;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.UUID;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ReaderFaucet
extends Faucet {
    public static final String TAG_SOURCE_PATH = "source";
    public static final String TAG_CHARSET = "charset";
    private static IPropertyDescriptor[] descriptors;
    public static final String SOURCE_PATH = "ReaderFaucet.SourcePath";
    public static final String CHARSET = "ReaderFaucet.Charset";
    protected static String[] charsetValues;
    protected String sourcePath = "";
    protected String charset = Charset.defaultCharset().displayName();
    protected com.koutra.dist.proc.faucet.ReaderFaucet representation;

    static {
        SortedMap<String, Charset> availableCharsets = Charset.availableCharsets();
        charsetValues = new String[availableCharsets.size()];
        charsetValues = availableCharsets.keySet().toArray(charsetValues);
        descriptors = new IPropertyDescriptor[]{new FileChooserPropertyDescriptor(SOURCE_PATH, Messages.ReaderFaucet_SourcePathPropertyDescription), new ComboBoxPropertyDescriptor((Object)CHARSET, Messages.ReaderFaucet_CharsetPropertyDescription, charsetValues)};
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getId().equals(SOURCE_PATH)) {
                ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        return null;
                    }
                });
            } else if (descriptors[i].getId().equals(CHARSET)) {
                ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        return null;
                    }
                });
            }
            ++i;
        }
    }

    @Override
    public ModelElement deepCopy() {
        ReaderFaucet retVal = new ReaderFaucet();
        retVal.sourcePath = this.sourcePath;
        retVal.charset = this.charset;
        if (this.connection != null && this.connection.getSink() != null) {
            retVal.connection = (Connection)this.connection.deepCopy();
            retVal.connection.connect(retVal, this.connection.getSink());
        }
        return retVal;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> superList = new ArrayList<IPropertyDescriptor>(Arrays.asList(super.getPropertyDescriptors()));
        superList.addAll(Arrays.asList(descriptors));
        IPropertyDescriptor[] retVal = new IPropertyDescriptor[superList.size()];
        int counter = 0;
        for (IPropertyDescriptor pd : superList) {
            retVal[counter++] = pd;
        }
        return retVal;
    }

    private int getCharsetValue(String name) {
        int i = 0;
        while (i < charsetValues.length) {
            if (charsetValues[i].equals(name)) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Unknown charset.");
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (SOURCE_PATH.equals(propertyId)) {
            return this.sourcePath;
        }
        if (CHARSET.equals(propertyId)) {
            return this.getCharsetValue(this.charset);
        }
        return super.getPropertyValue(propertyId);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (SOURCE_PATH.equals(propertyId)) {
            String oldValue = this.sourcePath;
            this.sourcePath = (String)value;
            this.firePropertyChange(SOURCE_PATH, oldValue, value);
        } else if (CHARSET.equals(propertyId)) {
            int oldValue = this.getCharsetValue(this.charset);
            this.charset = charsetValues[(Integer)value];
            this.firePropertyChange(CHARSET, oldValue, value);
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    @Override
    public boolean supportsOutput(ContentType contentType) {
        switch (contentType) {
            case CharStream: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "ReaderFaucet[" + this.sourcePath + "," + this.charset + "]";
    }

    @Override
    public void setUpExecution() {
        this.representation = new com.koutra.dist.proc.faucet.ReaderFaucet(UUID.randomUUID().toString(), this.sourcePath, this.charset);
        ModelElement sink = (ModelElement)((Object)this.getSinkConnection().getSink());
        sink.setUpExecution();
        ISink sinkRepresentation = (ISink)sink.getExecutionRepresentation();
        this.representation.hookupSink(sinkRepresentation);
    }

    @Override
    public Object getExecutionRepresentation() {
        if (this.representation == null) {
            this.setUpExecution();
        }
        return this.representation;
    }

    @Override
    public void dehydrate(IMemento memento) {
        memento.putString(TAG_SOURCE_PATH, this.sourcePath);
        memento.putString(TAG_CHARSET, this.charset);
        super.dehydrate(memento);
    }

    @Override
    public void hydrate(IMemento memento) {
        this.sourcePath = memento.getString(TAG_SOURCE_PATH);
        this.charset = memento.getString(TAG_CHARSET);
        super.hydrate(memento);
    }

    @Override
    public List<ValidationError> validate() {
        File f = new File(this.sourcePath);
        if (!f.canRead()) {
            return Collections.singletonList(new ValidationError(this, String.valueOf(Messages.ReaderFaucet_SourcePathValidationMessage) + this.sourcePath));
        }
        return Collections.emptyList();
    }
}

