/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model.pipeline;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.model.ContentType;
import com.koutra.dist.proc.designer.model.ModelElement;
import com.koutra.dist.proc.designer.model.PipelineItem;
import com.koutra.dist.proc.designer.model.ValidationError;
import com.koutra.dist.proc.designer.properties.FileChooserPropertyDescriptor;
import com.koutra.dist.proc.designer.utils.DevNullContentHandler;
import com.koutra.dist.proc.model.ISink;
import java.io.FileReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ReaderToXMLPipelineItem
extends PipelineItem {
    public static final String TAG_SCRIPT = "script";
    public static final String TAG_ENGINE_NAME = "engineName";
    private static IPropertyDescriptor[] descriptors;
    public static final String SCRIPT = "ReaderToXML.Script";
    public static final String ENGINE_NAME = "ReaderToXML.EngineName";
    protected static String[] engineNameValues;
    protected String scriptEngineName = engineNameValues[0];
    protected String script = "";
    protected com.koutra.dist.proc.pipeline.script.ReaderToXMLPipelineItem representation;

    static {
        ArrayList<String> engineNames = new ArrayList<String>();
        ScriptEngineManager mgr = new ScriptEngineManager();
        List<ScriptEngineFactory> factories = mgr.getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            if (!(factory.getScriptEngine() instanceof Invocable)) continue;
            engineNames.add(factory.getLanguageName());
        }
        engineNameValues = new String[engineNames.size()];
        engineNameValues = engineNames.toArray(engineNameValues);
        descriptors = new IPropertyDescriptor[]{new FileChooserPropertyDescriptor(SCRIPT, Messages.ReaderToXMLPipelineItem_ScriptPropertyDescription), new ComboBoxPropertyDescriptor((Object)ENGINE_NAME, Messages.ReaderToXMLPipelineItem_ScriptEnginePropertyDescription, engineNameValues)};
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getId().equals(SCRIPT)) {
                ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        return null;
                    }
                });
            } else if (descriptors[i].getId().equals(ENGINE_NAME)) {
                ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        return null;
                    }
                });
            }
            ++i;
        }
    }

    @Override
    public ModelElement deepCopy() {
        ReaderToXMLPipelineItem retVal = new ReaderToXMLPipelineItem();
        retVal.scriptEngineName = this.scriptEngineName;
        retVal.script = this.script;
        return retVal;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> superList = new ArrayList<IPropertyDescriptor>(Arrays.asList(super.getPropertyDescriptors()));
        superList.addAll(Arrays.asList(descriptors));
        IPropertyDescriptor[] retVal = new IPropertyDescriptor[superList.size()];
        int counter = 0;
        for (IPropertyDescriptor pd : superList) {
            retVal[counter++] = pd;
        }
        return retVal;
    }

    private int getTargetTypeValue(String name) {
        int i = 0;
        while (i < engineNameValues.length) {
            if (engineNameValues[i].equals(name)) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Unknown target type.");
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (SCRIPT.equals(propertyId)) {
            return this.script;
        }
        if (ENGINE_NAME.equals(propertyId)) {
            return this.getTargetTypeValue(this.scriptEngineName);
        }
        return super.getPropertyValue(propertyId);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (SCRIPT.equals(propertyId)) {
            String oldValue = this.script;
            this.script = (String)value;
            this.firePropertyChange(SCRIPT, oldValue, value);
        } else if (ENGINE_NAME.equals(propertyId)) {
            int oldValue = this.getTargetTypeValue(this.scriptEngineName);
            this.scriptEngineName = engineNameValues[(Integer)value];
            this.firePropertyChange(ENGINE_NAME, oldValue, value);
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    @Override
    public boolean supportsInput(ContentType contentType) {
        switch (contentType) {
            case CharStream: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsOutput(ContentType contentType) {
        switch (contentType) {
            case XML: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "ReaderToXML[" + this.scriptEngineName + "]";
    }

    @Override
    public void setUpExecution() {
        this.representation = new com.koutra.dist.proc.pipeline.script.ReaderToXMLPipelineItem(UUID.randomUUID().toString(), this.scriptEngineName, this.script);
        ModelElement sink = (ModelElement)((Object)this.getSinkConnection().getSink());
        sink.setUpExecution();
        ISink sinkRepresentation = (ISink)sink.getExecutionRepresentation();
        this.representation.hookupSink(sinkRepresentation);
    }

    @Override
    public Object getExecutionRepresentation() {
        if (this.representation == null) {
            this.setUpExecution();
        }
        return this.representation;
    }

    @Override
    public void dehydrate(IMemento memento) {
        memento.putString(TAG_SCRIPT, this.script);
        memento.putString(TAG_ENGINE_NAME, this.scriptEngineName);
        super.dehydrate(memento);
    }

    @Override
    public void hydrate(IMemento memento) {
        this.script = memento.getString(TAG_SCRIPT);
        this.scriptEngineName = memento.getString(TAG_ENGINE_NAME);
        super.hydrate(memento);
    }

    @Override
    public List<ValidationError> validate() {
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName(this.scriptEngineName);
        Invocable invocableEngine = (Invocable)((Object)engine);
        try {
            engine.eval(new FileReader(this.script));
        }
        catch (Exception e) {
            return Collections.singletonList(new ValidationError(this, MessageFormat.format(Messages.ReaderToXMLPipelineItem_ScriptEvaluationError, this.script, e.getMessage())));
        }
        try {
            invocableEngine.invokeFunction("transformBuffer", new char[0], 0, 0, new DevNullContentHandler());
        }
        catch (Throwable t) {
            return Collections.singletonList(new ValidationError(this, MessageFormat.format(Messages.ReaderToXMLPipelineItem_ScriptInvocationError, t.getMessage())));
        }
        return Collections.emptyList();
    }
}

