/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model.pipeline;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.model.Connection;
import com.koutra.dist.proc.designer.model.ContentType;
import com.koutra.dist.proc.designer.model.ModelElement;
import com.koutra.dist.proc.designer.model.PipelineItem;
import com.koutra.dist.proc.designer.model.ValidationError;
import com.koutra.dist.proc.model.ISink;
import com.koutra.dist.proc.model.ISinkTemplate;
import com.koutra.dist.proc.pipeline.XMLFilterDemuxPipelineItem;
import com.koutra.dist.proc.xml.XMLMuxFilter;
import com.koutra.dist.proc.xml.XPathXMLMuxFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class XMLXPathDemuxPipelineItem
extends PipelineItem {
    public static final String TAG_XPATH = "xpath";
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"XMLXPathDemuxPipelineItem.XPath", Messages.XMLXPathDemuxPipelineItem_XPathPropertyDescription)};
    public static final String XPATH = "XMLXPathDemuxPipelineItem.XPath";
    protected String xPath = "";
    protected XMLFilterDemuxPipelineItem representation;

    static {
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getId().equals(XPATH)) {
                ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        return null;
                    }
                });
            }
            ++i;
        }
    }

    @Override
    public ModelElement deepCopy() {
        XMLXPathDemuxPipelineItem retVal = new XMLXPathDemuxPipelineItem();
        retVal.xPath = this.xPath;
        if (this.sinkConnection != null && this.sinkConnection.getSink() != null) {
            retVal.sinkConnection = (Connection)this.sinkConnection.deepCopy();
            retVal.sinkConnection.connect(retVal, this.sinkConnection.getSink());
        }
        return retVal;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> superList = new ArrayList<IPropertyDescriptor>(Arrays.asList(super.getPropertyDescriptors()));
        superList.addAll(Arrays.asList(descriptors));
        IPropertyDescriptor[] retVal = new IPropertyDescriptor[superList.size()];
        int counter = 0;
        for (IPropertyDescriptor pd : superList) {
            retVal[counter++] = pd;
        }
        return retVal;
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (XPATH.equals(propertyId)) {
            return this.xPath;
        }
        return super.getPropertyValue(propertyId);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (XPATH.equals(propertyId)) {
            String oldValue = this.xPath;
            this.xPath = (String)value;
            this.firePropertyChange(XPATH, oldValue, value);
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    @Override
    public boolean supportsInput(ContentType contentType) {
        switch (contentType) {
            case XML: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsOutput(ContentType contentType) {
        switch (contentType) {
            case XML: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "XMLXPathDemux[" + this.xPath + "]";
    }

    @Override
    public void setUpExecution() {
        XPathXMLMuxFilter muxFilter = new XPathXMLMuxFilter(this.xPath);
        ModelElement sinkElement = (ModelElement)((Object)this.getSinkConnection().getSink());
        sinkElement.setUpExecution();
        ISinkTemplate template = (ISinkTemplate)sinkElement.getExecutionRepresentation();
        this.representation = new XMLFilterDemuxPipelineItem(UUID.randomUUID().toString(), (XMLMuxFilter)muxFilter, template);
        this.representation.hookupSink((ISink)template);
    }

    @Override
    public Object getExecutionRepresentation() {
        if (this.representation == null) {
            this.setUpExecution();
        }
        return this.representation;
    }

    @Override
    public void dehydrate(IMemento memento) {
        memento.putString(XPATH, this.xPath);
        super.dehydrate(memento);
    }

    @Override
    public void hydrate(IMemento memento) {
        this.xPath = memento.getString(XPATH);
        super.hydrate(memento);
    }

    @Override
    public List<ValidationError> validate() {
        return Collections.emptyList();
    }
}

