/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model.sink;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.model.ContentType;
import com.koutra.dist.proc.designer.model.ModelElement;
import com.koutra.dist.proc.designer.model.Sink;
import com.koutra.dist.proc.designer.model.ValidationError;
import com.koutra.dist.proc.designer.properties.ExternalFileChooserPropertyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class FOPSink
extends Sink {
    public static final String TAG_TARGET_PATH = "target";
    public static final String TAG_RESULT_TYPE = "resultType";
    private static IPropertyDescriptor[] descriptors;
    public static final String TARGET_PATH = "FOPSink.TargetPath";
    public static final String RESULT_TYPE = "FOPSink.ResultType";
    protected static String[] targetTypeValues;
    protected String targetPath = "";
    protected String resultType = "application/pdf";
    protected com.koutra.dist.proc.sink.FOPSink representation;

    static {
        targetTypeValues = new String[]{"application/pdf", "application/x-afp", "application/x-pcl", "application/postscript", "application/rtf", "text/plain"};
        descriptors = new IPropertyDescriptor[]{new ExternalFileChooserPropertyDescriptor(TARGET_PATH, Messages.FOPSink_TargetPathPropertyDescription), new ComboBoxPropertyDescriptor((Object)RESULT_TYPE, Messages.FOPSink_ResultTypePropertyDescription, targetTypeValues)};
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getId().equals(TARGET_PATH)) {
                ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        return null;
                    }
                });
            } else if (descriptors[i].getId().equals(RESULT_TYPE)) {
                ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        return null;
                    }
                });
            }
            ++i;
        }
    }

    @Override
    public ModelElement deepCopy() {
        FOPSink retVal = new FOPSink();
        retVal.targetPath = this.targetPath;
        retVal.resultType = this.resultType;
        return retVal;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> superList = new ArrayList<IPropertyDescriptor>(Arrays.asList(super.getPropertyDescriptors()));
        superList.addAll(Arrays.asList(descriptors));
        IPropertyDescriptor[] retVal = new IPropertyDescriptor[superList.size()];
        int counter = 0;
        for (IPropertyDescriptor pd : superList) {
            retVal[counter++] = pd;
        }
        return retVal;
    }

    private int getTargetTypeValue(String name) {
        int i = 0;
        while (i < targetTypeValues.length) {
            if (targetTypeValues[i].equals(name)) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Unknown target type.");
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (TARGET_PATH.equals(propertyId)) {
            return this.targetPath;
        }
        if (RESULT_TYPE.equals(propertyId)) {
            return this.getTargetTypeValue(this.resultType);
        }
        return super.getPropertyValue(propertyId);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (TARGET_PATH.equals(propertyId)) {
            String oldValue = this.targetPath;
            this.targetPath = (String)value;
            this.firePropertyChange(TARGET_PATH, oldValue, value);
        } else if (RESULT_TYPE.equals(propertyId)) {
            int oldValue = this.getTargetTypeValue(this.resultType);
            this.resultType = targetTypeValues[(Integer)value];
            this.firePropertyChange(RESULT_TYPE, oldValue, value);
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    @Override
    public boolean supportsInput(ContentType contentType) {
        switch (contentType) {
            case XML: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "FOPSink[" + this.targetPath + "," + this.resultType + "]";
    }

    @Override
    public void setUpExecution() {
        this.representation = new com.koutra.dist.proc.sink.FOPSink(UUID.randomUUID().toString(), this.resultType, this.targetPath);
    }

    @Override
    public Object getExecutionRepresentation() {
        if (this.representation == null) {
            this.setUpExecution();
        }
        return this.representation;
    }

    @Override
    public void dehydrate(IMemento memento) {
        memento.putString(TAG_TARGET_PATH, this.targetPath);
        memento.putString(TAG_RESULT_TYPE, this.resultType);
        super.dehydrate(memento);
    }

    @Override
    public void hydrate(IMemento memento) {
        this.targetPath = memento.getString(TAG_TARGET_PATH);
        this.resultType = memento.getString(TAG_RESULT_TYPE);
        super.hydrate(memento);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ValidationError> validate() {
        File f = new File(this.targetPath);
        try {
            if (!f.exists()) {
                if (!f.createNewFile()) return Collections.singletonList(new ValidationError(this, String.valueOf(Messages.FOPSink_TargetPathWriteError1) + this.targetPath));
                f.delete();
                return Collections.emptyList();
            } else {
                if (f.canWrite()) return Collections.emptyList();
                return Collections.singletonList(new ValidationError(this, String.valueOf(Messages.FOPSink_TargetPathWriteError2) + this.targetPath));
            }
        }
        catch (Exception exception) {
            return Collections.singletonList(new ValidationError(this, String.valueOf(Messages.FOPSink_TargetPathWriteError3) + this.targetPath));
        }
    }
}

