/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model.sink;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.model.ContentType;
import com.koutra.dist.proc.designer.model.IMuxSink;
import com.koutra.dist.proc.designer.model.ModelElement;
import com.koutra.dist.proc.designer.model.Sink;
import com.koutra.dist.proc.designer.model.ValidationError;
import com.koutra.dist.proc.designer.properties.ExternalFileChooserPropertyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class StreamMuxSink
extends Sink
implements IMuxSink {
    public static final String TAG_TARGET_PATH = "target";
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new ExternalFileChooserPropertyDescriptor("StreamMuxSink.TargetPath", Messages.StreamMuxSink_TargetPathPropertyDescription)};
    public static final String TARGET_PATH = "StreamMuxSink.TargetPath";
    protected String targetPath = "";
    protected com.koutra.dist.proc.sink.StreamMuxSink representation;

    static {
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getId().equals(TARGET_PATH)) {
                ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        return null;
                    }
                });
            }
            ++i;
        }
    }

    @Override
    public ModelElement deepCopy() {
        StreamMuxSink retVal = new StreamMuxSink();
        retVal.targetPath = this.targetPath;
        return retVal;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> superList = new ArrayList<IPropertyDescriptor>(Arrays.asList(super.getPropertyDescriptors()));
        superList.addAll(Arrays.asList(descriptors));
        IPropertyDescriptor[] retVal = new IPropertyDescriptor[superList.size()];
        int counter = 0;
        for (IPropertyDescriptor pd : superList) {
            retVal[counter++] = pd;
        }
        return retVal;
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (TARGET_PATH.equals(propertyId)) {
            return this.targetPath;
        }
        return super.getPropertyValue(propertyId);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (TARGET_PATH.equals(propertyId)) {
            String oldValue = this.targetPath;
            this.targetPath = (String)value;
            this.firePropertyChange(TARGET_PATH, oldValue, value);
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    @Override
    public boolean supportsInput(ContentType contentType) {
        switch (contentType) {
            case ByteStream: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "StreamMuxSink[" + this.targetPath + "]";
    }

    @Override
    public void setUpExecution() {
        this.representation = new com.koutra.dist.proc.sink.StreamMuxSink(UUID.randomUUID().toString(), this.targetPath);
    }

    @Override
    public Object getExecutionRepresentation() {
        if (this.representation == null) {
            this.setUpExecution();
        }
        return this.representation;
    }

    @Override
    public void dehydrate(IMemento memento) {
        memento.putString(TAG_TARGET_PATH, this.targetPath);
        super.dehydrate(memento);
    }

    @Override
    public void hydrate(IMemento memento) {
        this.targetPath = memento.getString(TAG_TARGET_PATH);
        super.hydrate(memento);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ValidationError> validate() {
        File f = new File(this.targetPath);
        try {
            if (!f.exists()) {
                if (!f.createNewFile()) return Collections.singletonList(new ValidationError(this, String.valueOf(Messages.StreamMuxSink_TargetPathWriteError1) + this.targetPath));
                f.delete();
                return Collections.emptyList();
            } else {
                if (f.canWrite()) return Collections.emptyList();
                return Collections.singletonList(new ValidationError(this, String.valueOf(Messages.StreamMuxSink_TargetPathWriteError2) + this.targetPath));
            }
        }
        catch (Exception exception) {
            return Collections.singletonList(new ValidationError(this, String.valueOf(Messages.StreamMuxSink_TargetPathWriteError3) + this.targetPath));
        }
    }
}

