/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.model.template;

import com.koutra.dist.proc.designer.Messages;
import com.koutra.dist.proc.designer.model.Connection;
import com.koutra.dist.proc.designer.model.ContentType;
import com.koutra.dist.proc.designer.model.IDemuxFaucet;
import com.koutra.dist.proc.designer.model.IMuxSink;
import com.koutra.dist.proc.designer.model.ISink;
import com.koutra.dist.proc.designer.model.ModelElement;
import com.koutra.dist.proc.designer.model.Template;
import com.koutra.dist.proc.designer.model.ValidationError;
import com.koutra.dist.proc.designer.model.template.TaskBoundaryTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class XMLTaskBoundaryTemplate
extends TaskBoundaryTemplate {
    protected com.koutra.dist.proc.pipeline.XMLTaskBoundaryTemplate representation;

    @Override
    public ModelElement deepCopy() {
        XMLTaskBoundaryTemplate retVal = new XMLTaskBoundaryTemplate();
        if (this.sinkConnection != null && this.sinkConnection.getSink() != null) {
            retVal.sinkConnection = (Connection)this.sinkConnection.deepCopy();
            retVal.sinkConnection.connect(retVal, this.sinkConnection.getSink());
        }
        return retVal;
    }

    @Override
    public boolean supportsInput(ContentType contentType) {
        switch (contentType) {
            case XML: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsOutput(ContentType contentType) {
        switch (contentType) {
            case XML: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "XMLTaskBoundaryTemplate";
    }

    @Override
    public void setUpExecution() {
        this.representation = new com.koutra.dist.proc.pipeline.XMLTaskBoundaryTemplate(UUID.randomUUID().toString());
        ModelElement sink = (ModelElement)((Object)this.getSinkConnection().getSink());
        sink.setUpExecution();
        com.koutra.dist.proc.model.ISink sinkRepresentation = (com.koutra.dist.proc.model.ISink)sink.getExecutionRepresentation();
        this.representation.hookupSink(sinkRepresentation);
    }

    @Override
    public Object getExecutionRepresentation() {
        if (this.representation == null) {
            this.setUpExecution();
        }
        return this.representation;
    }

    @Override
    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        boolean isPipelineStart = this.faucetConnection.getFaucet() instanceof IDemuxFaucet;
        boolean isPipelineEnd = this.sinkConnection.getSink() instanceof IMuxSink;
        if (!isPipelineStart && !isPipelineEnd || isPipelineStart && isPipelineEnd) {
            errors.add(new ValidationError(this, Messages.XMLTaskBoundaryTemplate_BoundaryDemuxValidationError));
        }
        if (isPipelineStart) {
            ISink nextSink;
            boolean foundMatchingTaskBoundary = false;
            Template template = this;
            while ((nextSink = template.getSinkConnection().getSink()) instanceof Template) {
                if (nextSink instanceof TaskBoundaryTemplate) {
                    foundMatchingTaskBoundary = true;
                    break;
                }
                template = (Template)nextSink;
            }
            if (!foundMatchingTaskBoundary) {
                errors.add(new ValidationError(this, Messages.XMLTaskBoundaryTemplate_SingleBoundaryInPipelineValidationError));
            }
        }
        return errors;
    }
}

