/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.preferences;

import com.koutra.dist.proc.designer.KoutraXformPlugin;
import com.koutra.dist.proc.designer.Messages;
import java.io.File;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class KoutraXformPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text libraryPath;

    public KoutraXformPreferencePage() {
        this.setPreferenceStore(KoutraXformPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.KoutraXformPreferencePage_Description);
    }

    protected Control createContents(final Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout());
        Group classpathContainerGroup = new Group(container, 0);
        classpathContainerGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        classpathContainerGroup.setText(Messages.KoutraXformPreferencePage_GroupText);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        classpathContainerGroup.setLayout((Layout)gridLayout);
        this.libraryPath = new Text((Composite)classpathContainerGroup, 18436);
        this.libraryPath.setText(this.getCurrentValue());
        this.libraryPath.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.libraryPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                File f = new File(KoutraXformPreferencePage.this.libraryPath.getText());
                KoutraXformPreferencePage.this.setValid(f.isDirectory());
            }
        });
        Button browseBtn = new Button((Composite)classpathContainerGroup, 8);
        browseBtn.setText(Messages.KoutraXformPreferencePage_BrowseButtonText);
        browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell());
                dialog.setText(Messages.KoutraXformPreferencePage_DialogTitle);
                dialog.setMessage(Messages.KoutraXformPreferencePage_DialogMessage);
                String userSelection = dialog.open();
                if (userSelection == null) {
                    return;
                }
                File f = new File(userSelection);
                if (!f.isDirectory()) {
                    return;
                }
                KoutraXformPreferencePage.this.libraryPath.setText(f.getAbsolutePath());
                KoutraXformPreferencePage.this.setValid(true);
            }
        });
        return container;
    }

    private String getCurrentValue() {
        String value = KoutraXformPlugin.getDefault().getPreferenceStore().getString("KOUTRAXFORM_LIB_LOCATION");
        File f = new File(value);
        this.setValid(f.isDirectory());
        return value;
    }

    public boolean performOk() {
        KoutraXformPlugin.getDefault().getPreferenceStore().setValue("KOUTRAXFORM_LIB_LOCATION", this.libraryPath.getText());
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.libraryPath.setText(KoutraXformPlugin.getDefault().getPreferenceStore().getDefaultString("KOUTRAXFORM_LIB_LOCATION"));
        this.setValid(false);
    }

    public void init(IWorkbench workbench) {
    }
}

