/*
 * Decompiled with CFR 0.152.
 */
package com.koutra.dist.proc.designer.properties;

import com.koutra.dist.proc.designer.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileCellEditor
extends DialogCellEditor {
    private Composite parent;
    private CLabel label;

    public FileCellEditor(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
    }

    protected Control createContents(Composite cell) {
        this.label = new CLabel(cell, 0x1000000);
        this.label.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (FileCellEditor.this.getErrorMessage() != null) {
                    MessageDialog.openError((Shell)FileCellEditor.this.parent.getShell(), (String)Messages.FileCellEditor_InvalidResourceDialogTitle, (String)FileCellEditor.this.getErrorMessage());
                }
                super.focusLost(e);
            }
        });
        return this.label;
    }

    protected void updateContents(Object value) {
        this.label.setText(value != null ? value.toString() : "");
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        IWorkspaceRoot rootElement = ResourcesPlugin.getWorkspace().getRoot();
        dialog.setAllowMultiple(false);
        dialog.setHelpAvailable(false);
        dialog.setTitle(Messages.FileCellEditor_FileChooserTitle);
        dialog.setMessage(Messages.FileCellEditor_FileChooserMessage);
        dialog.setInput((Object)rootElement);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results == null || results.length == 0) {
            return null;
        }
        IFile file = (IFile)results[0];
        return file.getLocation().toOSString();
    }
}

