/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.crypto;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.util.StringUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.annotation.Nullable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Base64;

public abstract class CryptUtils {
    private static final Logger logger = Logger.get(CryptUtils.class);
    private static final Random random = new SecureRandom();

    public static byte[] encrypt(byte[] plainData, byte[] key, boolean usePadding) throws IllegalBlockSizeException {
        try {
            String cipherTransformation = String.format("AES/ECB/%s", usePadding ? "PKCS5Padding" : "NoPadding");
            return CryptUtils.doCrypt(plainData, key, cipherTransformation, 128, 1);
        }
        catch (BadPaddingException e) {
            throw logger.bug(e, "Should only occur in decryption mode.", new Object[0]);
        }
    }

    public static byte[] decrypt(byte[] encryptedData, byte[] key, boolean usePadding) throws BadPaddingException {
        try {
            String cipherTransformation = String.format("AES/ECB/%s", usePadding ? "PKCS5Padding" : "NoPadding");
            return CryptUtils.doCrypt(encryptedData, key, cipherTransformation, 128, 2);
        }
        catch (IllegalBlockSizeException e) {
            throw logger.bug(e, "Should only occur in encryption mode.", new Object[0]);
        }
    }

    public static byte[] doCrypt(byte[] data, byte[] key, String cipherTransformation, int blockBitSize, int mode) throws IllegalBlockSizeException, BadPaddingException {
        byte[] blockSizedKey = key;
        int blockByteSize = blockBitSize / 8;
        if (blockSizedKey.length != blockByteSize) {
            blockSizedKey = new byte[blockByteSize];
            System.arraycopy(key, 0, blockSizedKey, 0, blockByteSize);
        }
        try {
            Cipher cipher = Cipher.getInstance(cipherTransformation);
            cipher.init(mode, new SecretKeySpec(blockSizedKey, "AES"));
            return cipher.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(StringUtils.strf("Cipher transformation: %s, is not valid or not supported by the provider.", cipherTransformation), e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalStateException(StringUtils.strf("Cipher transformation: %s, uses a padding scheme that is not valid or not supported by the provider.", cipherTransformation), e);
        }
        catch (InvalidKeyException e) {
            throw logger.bug(e, "Key is inappropriate for cipher.", new Object[0]);
        }
    }

    public static byte[] xor(byte[] data1, byte[] data2) {
        Preconditions.checkArgument(data1.length == data2.length, "Cannot XOR two data sets of different length.");
        byte[] data = new byte[data1.length];
        for (int i = 0; i < data1.length; ++i) {
            data[i] = (byte)(data1[i] ^ data2[i]);
        }
        return data;
    }

    public static byte[] newRandomBlock(int bitSize) {
        byte[] block = new byte[bitSize / 8];
        random.nextBytes(block);
        return block;
    }

    @Nullable
    public static String encodeBase64(@Nullable byte[] plainData) {
        if (plainData == null || plainData.length == 0) {
            return null;
        }
        return new String(Base64.encode(plainData), Charsets.UTF_8);
    }

    public static byte[] decodeBase64(@Nullable String b64Data) {
        if (b64Data == null || b64Data.isEmpty()) {
            return new byte[0];
        }
        return Base64.decode(b64Data.getBytes(Charsets.UTF_8));
    }
}

