/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.crypto.gpg;

import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GPG {
    private static final Logger logger = LoggerFactory.getLogger(GPG.class);

    public static long parseKeyId(String keyId) {
        double doubleKeyId;
        String trimmedKeyId = keyId.startsWith("0x") ? keyId.substring(2) : keyId;
        long firstChar = Long.decode("0x" + trimmedKeyId.substring(0, 1));
        long otherChars = Long.decode("0x" + trimmedKeyId.substring(1));
        for (doubleKeyId = (double)firstChar * Math.pow(16.0, trimmedKeyId.length() - 1) + (double)otherChars; doubleKeyId > 9.223372036854776E18; doubleKeyId -= -1.0) {
        }
        return (long)doubleKeyId;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"})
    public static PGPPublicKey getPublicKey(File publicKeyFile, long publicKeyId) throws IOException, PGPException {
        try (FileInputStream publicKeyInputStream = new FileInputStream(publicKeyFile);){
            PGPPublicKey pGPPublicKey = new PGPPublicKeyRing(publicKeyInputStream).getPublicKey(publicKeyId);
            return pGPPublicKey;
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"})
    public static PGPSecretKey getPrivateKey(File privateKeyFile, long privateKeyId) throws IOException, PGPException {
        try (FileInputStream privateKeyInputStream = new FileInputStream(privateKeyFile);){
            PGPSecretKeyRingCollection privateKeyRing = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(privateKeyInputStream));
            PGPSecretKey pGPSecretKey = privateKeyRing.getSecretKey(privateKeyId);
            return pGPSecretKey;
        }
    }

    @Nullable
    public static PGPSecretKey getPrivateKeyFor(File encryptedFile, File privateKeyFile) throws IOException, PGPException {
        try (FileInputStream encryptedFileStream = new FileInputStream(encryptedFile);){
            PGPSecretKey pGPSecretKey = GPG.getPrivateKeyFor(encryptedFileStream, privateKeyFile);
            return pGPSecretKey;
        }
    }

    @Nullable
    public static PGPSecretKey getPrivateKeyFor(InputStream encryptedStream, File privateKeyFile) throws IOException, PGPException {
        InputStream encryptedDataStream = PGPUtil.getDecoderStream(encryptedStream);
        PGPObjectFactory encryptedDataFactory = new PGPObjectFactory(encryptedDataStream);
        Object encryptedDataObjects = encryptedDataFactory.nextObject();
        if (!(encryptedDataObjects instanceof PGPEncryptedDataList)) {
            encryptedDataObjects = encryptedDataFactory.nextObject();
        }
        Iterator encryptedDataIterator = ((PGPEncryptedDataList)encryptedDataObjects).getEncryptedDataObjects();
        PGPSecretKey privateKey = null;
        while (privateKey == null && encryptedDataIterator.hasNext()) {
            PGPPublicKeyEncryptedData encryptedData = (PGPPublicKeyEncryptedData)encryptedDataIterator.next();
            privateKey = GPG.getPrivateKey(privateKeyFile, encryptedData.getKeyID());
        }
        return privateKey;
    }

    public static List<PrintableKeyWrapper<PGPSecretKey>> getPrivateKeys(File privateKeyFile) throws IOException, PGPException {
        try (FileInputStream privateKeyInputStream = new FileInputStream(privateKeyFile);){
            ArrayList<PrintableKeyWrapper<PGPSecretKey>> keys = new ArrayList<PrintableKeyWrapper<PGPSecretKey>>();
            PGPSecretKeyRingCollection privateKeyRing = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(privateKeyInputStream));
            Iterator rings = privateKeyRing.getKeyRings();
            while (rings.hasNext()) {
                Iterator ring = ((PGPSecretKeyRing)rings.next()).getSecretKeys();
                while (ring.hasNext()) {
                    PGPSecretKey key = (PGPSecretKey)ring.next();
                    if (!key.getUserIDs().hasNext()) continue;
                    keys.add(new PrintableKeyWrapper<PGPSecretKey>(key, Long.valueOf(key.getKeyID())){

                        @Override
                        public String toString() {
                            return ((PGPSecretKey)this.getKey()).getUserIDs().next().toString();
                        }
                    });
                }
            }
            ArrayList<PrintableKeyWrapper<PGPSecretKey>> arrayList = keys;
            return arrayList;
        }
    }

    public static List<PrintableKeyWrapper<PGPPublicKey>> getPublicKeys(File publicKeyFile) throws IOException, PGPException {
        try (FileInputStream publicKeyInputStream = new FileInputStream(publicKeyFile);){
            ArrayList<PrintableKeyWrapper<PGPPublicKey>> keys = new ArrayList<PrintableKeyWrapper<PGPPublicKey>>();
            PGPPublicKeyRingCollection privateKeyRing = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(publicKeyInputStream));
            Iterator rings = privateKeyRing.getKeyRings();
            while (rings.hasNext()) {
                Iterator ring = ((PGPPublicKeyRing)rings.next()).getPublicKeys();
                while (ring.hasNext()) {
                    PGPPublicKey key = (PGPPublicKey)ring.next();
                    if (!key.getUserIDs().hasNext()) continue;
                    keys.add(new PrintableKeyWrapper<PGPPublicKey>(key, Long.valueOf(key.getKeyID())){

                        @Override
                        public String toString() {
                            return ((PGPPublicKey)this.getKey()).getUserIDs().next().toString();
                        }
                    });
                }
            }
            ArrayList<PrintableKeyWrapper<PGPPublicKey>> arrayList = keys;
            return arrayList;
        }
    }

    public static void encryptFile(File plainFile, File encryptedFile, PGPPublicKey publicKey, boolean armoured) throws NoSuchProviderException, IOException, PGPException {
        try (FileOutputStream encryptedOutputStream = new FileOutputStream(encryptedFile);
             FileInputStream plainInputStream = new FileInputStream(plainFile);
             InputStream encryptedInputStream = GPG.encrypt(plainInputStream, publicKey, armoured);){
            ByteStreams.copy(encryptedInputStream, encryptedOutputStream);
        }
    }

    public static byte[] encrypt(byte[] plainTextData, PGPPublicKey publicKey, boolean armoured) throws NoSuchProviderException, IOException, PGPException {
        return ByteStreams.toByteArray(GPG.encrypt(new ByteArrayInputStream(plainTextData), publicKey, armoured));
    }

    /*
     * Exception decompiling
     */
    public static InputStream encrypt(InputStream plainTextStream, PGPPublicKey publicKey, boolean armoured) throws IOException, NoSuchProviderException, PGPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void decryptFile(File encryptedFile, File plainTextFile, PGPSecretKey privateKey, String passPhrase) throws NoSuchProviderException, IOException, PGPException {
        try (FileInputStream encryptedInputStream = new FileInputStream(encryptedFile);
             InputStream decryptedInputStream = GPG.decrypt(encryptedInputStream, privateKey, passPhrase);
             FileOutputStream decryptedOutputStream = new FileOutputStream(plainTextFile);){
            ByteStreams.copy(decryptedInputStream, decryptedOutputStream);
        }
    }

    public static byte[] decrypt(byte[] encryptedData, PGPSecretKey privateKey, String passPhrase) throws NoSuchProviderException, IOException, PGPException {
        return ByteStreams.toByteArray(GPG.decrypt(new ByteArrayInputStream(encryptedData), privateKey, passPhrase));
    }

    public static InputStream decrypt(InputStream encryptedStream, PGPSecretKey privateKey, String passPhrase) throws IOException, PGPException, NoSuchProviderException {
        InputStream encryptedDataStream = PGPUtil.getDecoderStream(encryptedStream);
        PGPObjectFactory encryptedDataFactory = new PGPObjectFactory(encryptedDataStream);
        Object encryptedDataObjects = null;
        do {
            try {
                encryptedDataObjects = encryptedDataFactory.nextObject();
            }
            catch (IOException e) {
                logger.warn(e.getMessage());
            }
        } while (!(encryptedDataObjects instanceof PGPEncryptedDataList) && encryptedDataObjects != null);
        if (encryptedDataObjects == null) {
            throw new PGPException("No encrypted objects found.");
        }
        Iterator encryptedDataIterator = ((PGPEncryptedDataList)encryptedDataObjects).getEncryptedDataObjects();
        PGPPublicKeyEncryptedData encryptedData = null;
        while (encryptedDataIterator.hasNext() && (encryptedData = (PGPPublicKeyEncryptedData)encryptedDataIterator.next()).getKeyID() != privateKey.getKeyID()) {
        }
        if (encryptedData == null) {
            throw new PGPException("No encrypted data found.");
        }
        InputStream unencryptedStream = encryptedData.getDataStream(privateKey.extractPrivateKey(passPhrase.toCharArray(), BouncyCastleProvider.PROVIDER_NAME), BouncyCastleProvider.PROVIDER_NAME);
        PGPObjectFactory pgpFactory = new PGPObjectFactory(unencryptedStream);
        Object unencryptedObject = pgpFactory.nextObject();
        if (unencryptedObject instanceof PGPCompressedData) {
            PGPCompressedData compressedData = (PGPCompressedData)unencryptedObject;
            pgpFactory = new PGPObjectFactory(compressedData.getDataStream());
            unencryptedObject = pgpFactory.nextObject();
        }
        if (encryptedData.isIntegrityProtected() && !encryptedData.verify()) {
            throw new PGPException("Message integrity check failed.");
        }
        if (unencryptedObject == null) {
            throw new PGPException("No encrypted data found.");
        }
        if (unencryptedObject instanceof PGPOnePassSignatureList) {
            throw new PGPException("Encrypted data is a signature, not an encrypted message.");
        }
        if (!(unencryptedObject instanceof PGPLiteralData)) {
            throw new PGPException("Message type unrecognized: " + unencryptedObject.getClass());
        }
        PGPLiteralData unencryptedData = (PGPLiteralData)unencryptedObject;
        return unencryptedData.getInputStream();
    }

    public static void signFile(File dataFile, File signedFile, PGPSecretKey privateKey, String passPhrase, boolean armoured) throws NoSuchAlgorithmException, NoSuchProviderException, SignatureException, PGPException, IOException {
        try (FileInputStream dataInputStream = new FileInputStream(dataFile);
             InputStream signedInputStream = GPG.sign(dataInputStream, privateKey, passPhrase, armoured);
             FileOutputStream signedOutputStream = new FileOutputStream(signedFile);){
            ByteStreams.copy(signedInputStream, signedOutputStream);
        }
    }

    public static byte[] sign(byte[] data, PGPSecretKey privateKey, String passPhrase, boolean armoured) throws NoSuchAlgorithmException, NoSuchProviderException, SignatureException, IOException, PGPException {
        return ByteStreams.toByteArray(GPG.sign(new ByteArrayInputStream(data), privateKey, passPhrase, armoured));
    }

    /*
     * Exception decompiling
     */
    public static InputStream sign(InputStream data, PGPSecretKey privateKey, String passPhrase, boolean armoured) throws NoSuchAlgorithmException, NoSuchProviderException, PGPException, SignatureException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    private static class PrintableKeyWrapper<K> {
        private final K key;
        private final Long keyId;

        PrintableKeyWrapper(K key, Long keyId) {
            this.key = key;
            this.keyId = keyId;
        }

        public K getKey() {
            return this.key;
        }

        public Long getKeyID() {
            return this.keyId;
        }

        public String toString() {
            return this.key.toString();
        }
    }
}

