/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.lyndir.lhunath.opal.system.MessageDigests;
import com.lyndir.lhunath.opal.system.logging.Logger;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Formatter;
import javax.annotation.Nullable;

public abstract class CodeUtils {
    static final Logger logger = Logger.get(CodeUtils.class);

    public static byte[] digest(MessageDigests digest, String input, Charset charset) {
        return CodeUtils.digest(digest.get(), input, charset);
    }

    public static byte[] digest(MessageDigest digest, String input, Charset charset) {
        return CodeUtils.digest(digest, input.getBytes(charset));
    }

    public static byte[] digest(MessageDigests digest, byte[] input) {
        return CodeUtils.digest(digest.get(), input);
    }

    public static byte[] digest(MessageDigest digest, byte[] input) {
        return digest.digest(input);
    }

    public static String encodeHex(@Nullable byte[] data) {
        return CodeUtils.encodeHex(data, false);
    }

    public static String encodeHex(@Nullable byte[] data, boolean pretty) {
        StringBuilder bytes = new StringBuilder(data == null ? 0 : (data.length + (pretty ? 1 : 0)) * 2);
        try (Formatter formatter = new Formatter(bytes);){
            String format = String.format("%%02X%s", pretty ? ":" : "");
            if (data != null) {
                for (byte b : data) {
                    formatter.format(format, b);
                }
            }
        }
        if (pretty && bytes.length() > 0) {
            bytes.deleteCharAt(bytes.length() - 1);
        }
        return bytes.toString();
    }

    public static byte[] decodeHex(@Nullable String hexString) {
        if (hexString == null) {
            return new byte[0];
        }
        byte[] deviceToken = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length(); i += 2) {
            deviceToken[i / 2] = Integer.valueOf(hexString.substring(i, i + 2), 16).byteValue();
        }
        return deviceToken;
    }

    public static URL encodeURL(String urlFormat, String urlParam1, String ... otherURLParams) {
        StringBuilder url = new StringBuilder();
        int lastURLFormatOffset = 0;
        int urlFormatIndex = 0;
        int urlFormatOffset = 0;
        while ((urlFormatOffset = urlFormat.indexOf("{}", urlFormatOffset)) != -1) {
            url.append(urlFormat.substring(lastURLFormatOffset, urlFormatOffset));
            if (urlFormatIndex == 0) {
                url.append(CodeUtils.encodeURL(urlParam1));
            } else {
                Preconditions.checkElementIndex(urlFormatIndex - 1, otherURLParams.length, "Not enough URL encoding parameters given.");
                url.append(CodeUtils.encodeURL(otherURLParams[urlFormatIndex - 1]));
            }
            lastURLFormatOffset = urlFormatOffset += 2;
            ++urlFormatIndex;
        }
        try {
            return new URL(url.toString());
        }
        catch (MalformedURLException e) {
            logger.err(e, "The URL template does not appear to specify a valid URL: %s", urlFormat);
            throw new IllegalArgumentException(e);
        }
    }

    public static String encodeURL(String plainString) {
        return CodeUtils.encodeURL(plainString, Charsets.UTF_8);
    }

    private static String encodeURL(String plainString, Charset encoding) {
        try {
            return URLEncoder.encode(plainString, encoding.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw logger.bug(e, "Given encoding not supported: %s", encoding);
        }
    }
}

