/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system;

import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSource;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.util.IOUtils;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public enum MessageAuthenticationDigests {
    HmacMD5("HmacMD5"),
    HmacSHA1("HmacSHA1"),
    HmacSHA256("HmacSHA256"),
    HmacSHA384("HmacSHA384"),
    HmacSHA512("HmacSHA512");

    static final Logger logger;
    private final String jcaName;

    private MessageAuthenticationDigests(String jcaName) {
        this.jcaName = jcaName;
    }

    public Mac get() {
        try {
            return Mac.getInstance(this.getJCAName());
        }
        catch (NoSuchAlgorithmException e) {
            throw logger.bug(e);
        }
    }

    public String getJCAName() {
        return this.jcaName;
    }

    public byte[] of(byte[] key, byte[] bytes) {
        return this.of(key, IOUtils.supply(bytes));
    }

    public byte[] of(byte[] key, ByteSource source) {
        try {
            final Mac mac = this.get();
            mac.init(new SecretKeySpec(key, mac.getAlgorithm()));
            return source.read(new ByteProcessor<byte[]>(){

                @Override
                public boolean processBytes(byte[] buf, int off, int len) {
                    mac.update(buf, off, len);
                    return true;
                }

                @Override
                public byte[] getResult() {
                    return mac.doFinal();
                }
            });
        }
        catch (IOException | InvalidKeyException e) {
            throw logger.bug(e);
        }
    }

    static {
        logger = Logger.get(MessageAuthenticationDigests.class);
    }
}

