/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.lyndir.lhunath.opal.system.logging.Logger;
import com.lyndir.lhunath.opal.system.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public enum MessageDigests {
    MD2("MD2"),
    MD5("MD5"),
    SHA1("SHA-1"),
    SHA256("SHA-256"),
    SHA384("SHA-384"),
    SHA512("SHA-512");

    static final Logger logger;
    private final String jcaName;

    private MessageDigests(String jcaName) {
        this.jcaName = jcaName;
    }

    public MessageDigest get() {
        try {
            return MessageDigest.getInstance(this.getJCAName());
        }
        catch (NoSuchAlgorithmException e) {
            throw logger.bug(e);
        }
    }

    public String getJCAName() {
        return this.jcaName;
    }

    public byte[] of(byte[] bytes) {
        return this.of(IOUtils.supply(bytes));
    }

    public byte[] of(ByteSource supplier) {
        try {
            return this.get().digest(supplier.read());
        }
        catch (IOException e) {
            throw logger.bug(e);
        }
    }

    public byte[] of(InputStream stream) {
        try {
            return this.get().digest(ByteStreams.toByteArray(stream));
        }
        catch (IOException e) {
            throw logger.bug(e);
        }
    }

    static {
        logger = Logger.get(MessageDigests.class);
    }
}

