/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;

public class Poller<K, E> {
    private final Map<K, Queue<E>> queues = Collections.synchronizedMap(new HashMap());

    public void offer(K owner, E element) {
        Queue<E> queue = this.queues.get(owner);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue();
            this.queues.put(owner, queue);
        }
        queue.offer(element);
    }

    @Nullable
    public E poll(K owner) {
        if (owner != null && this.queues.containsKey(owner)) {
            return this.queues.get(owner).poll();
        }
        return null;
    }

    @Nullable
    public K pollKey() {
        for (Map.Entry<K, Queue<E>> queueEntry : this.queues.entrySet()) {
            if (queueEntry.getValue().isEmpty()) continue;
            return queueEntry.getKey();
        }
        return null;
    }
}

