/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system;

import com.lyndir.lhunath.opal.system.util.DateUtils;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nullable;

public abstract class Schedule
implements Runnable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Timer scheduler = new Timer("Scheduler", true);
    @Nullable
    private transient TimerTask scheduleTask;
    private transient boolean isScheduled;
    private final Calendar nextSchedule;
    private final int stepAmount;
    private final int stepField;

    protected Schedule(long time, int steps, int step) {
        int field;
        this.stepAmount = steps;
        this.stepField = step;
        this.nextSchedule = Calendar.getInstance();
        Calendar baseSchedule = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        baseSchedule.setTimeInMillis(time);
        Iterator i$ = DateUtils.calendarFields.iterator();
        while (i$.hasNext() && (field = ((Integer)i$.next()).intValue()) != this.stepField) {
            this.nextSchedule.set(field, baseSchedule.get(field));
        }
        Date now = new Date();
        while (this.nextSchedule.getTime().after(now)) {
            this.nextSchedule.add(this.stepField, -1);
        }
    }

    protected void scheduleRun() {
        assert (this.nextSchedule != null);
        Date now = new Date();
        while (this.nextSchedule.getTime().before(now)) {
            this.nextSchedule.add(this.stepField, this.stepAmount);
        }
        this.scheduleTask = new TimerTask(){

            @Override
            public void run() {
                Schedule.this.run();
                Schedule.this.scheduleRun();
            }
        };
        scheduler.schedule(this.scheduleTask, this.nextSchedule.getTime());
        this.isScheduled = true;
    }

    public void start() {
        if (!this.isScheduled) {
            this.scheduleRun();
        }
    }

    public void cancel() {
        if (this.scheduleTask != null) {
            this.scheduleTask.cancel();
        }
    }

    public void now() {
        this.cancel();
        new Thread((Runnable)this, "Forced Schedule").start();
        this.scheduleRun();
    }

    public abstract String getDescription();

    public String toString() {
        int field;
        StringBuffer time = new StringBuffer();
        Iterator i$ = DateUtils.calendarFields.iterator();
        while (i$.hasNext() && (field = ((Integer)i$.next()).intValue()) != this.stepField) {
            time.insert(0, String.format("%02d%s", this.nextSchedule.get(field), DateUtils.calendarSuffix(field)));
        }
        String desc = DateUtils.calendarDesc.get(this.stepField).toLowerCase(Locale.ENGLISH);
        if (this.stepAmount > 1) {
            desc = desc + 's';
        }
        return String.format("%s (Every %d %s at %s)", this.getDescription(), this.stepAmount, desc, time);
    }
}

