/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.lyndir.lhunath.opal.system.dummy.NullOutputStream;
import com.lyndir.lhunath.opal.system.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import javax.annotation.Nullable;

public class Shell {
    static final Logger logger = Logger.get(Shell.class);
    protected static final int BUFFER_SIZE = 4096;

    @Nullable
    public static Process exec(boolean block, File currDir, String ... cmd) {
        Process process = Shell.exec(System.out, System.err, currDir, cmd);
        if (block && process != null) {
            Shell.waitFor(process);
        }
        return process;
    }

    public static int waitFor(@Nullable Process process) {
        if (process == null) {
            return -256;
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            logger.err(e, "Process interrupted!", new Object[0]);
            process.destroy();
        }
        return process.exitValue();
    }

    @Nullable
    public static Process exec(final OutputStream out, final OutputStream err, File currDir, String ... cmd) {
        int bytesRead;
        char[] buffer = new char[100];
        String[] execCmd = cmd;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(new File(currDir, cmd[0])), Charsets.US_ASCII);){
            bytesRead = reader.read(buffer);
        }
        catch (IOException e) {
            logger.err(e, "Failed to open the file to execute!", new Object[0]);
            return null;
        }
        String head = new String(buffer, 0, bytesRead);
        int eol = head.indexOf(System.lineSeparator());
        if (eol > 0 && "#!".equals((head = head.substring(0, eol)).substring(0, 2))) {
            String shell = head.substring(2);
            LinkedList<String> cmdList = new LinkedList<String>(Arrays.asList(cmd));
            cmdList.addFirst(shell.trim());
            execCmd = cmdList.toArray(cmd);
        }
        try {
            final Process process = Runtime.getRuntime().exec(execCmd, null, currDir);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try (InputStream inputStream = process.getInputStream();){
                        ByteStreams.copy(inputStream, out);
                    }
                    catch (IOException e) {
                        logger.err(e, "Couldn't read from process or write to stdout!", new Object[0]);
                    }
                }
            }, cmd[0] + " stdout").start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try (InputStream errorStream = process.getErrorStream();){
                        ByteStreams.copy(errorStream, err);
                    }
                    catch (IOException e) {
                        logger.err(e, "Couldn't read from process or write to stderr!", new Object[0]);
                    }
                }
            }, cmd[0] + " stderr").start();
            return process;
        }
        catch (IOException e) {
            logger.err(e, "Could not start process %s!", cmd[0]);
            return null;
        }
    }

    @Nullable
    public static String execRead(Charset charset, File currDir, String ... cmd) {
        try {
            PipedOutputStream output = new PipedOutputStream();
            Shell.exec(output, new NullOutputStream(), currDir, cmd);
            return CharStreams.toString(new InputStreamReader((InputStream)new PipedInputStream(output), charset));
        }
        catch (FileNotFoundException e) {
            logger.err(e, "Command to execute was not found!", new Object[0]);
        }
        catch (IOException e) {
            logger.err(e, "Failed to read from the process!", new Object[0]);
        }
        return null;
    }
}

