/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system;

import com.google.common.collect.ImmutableList;
import com.lyndir.lhunath.opal.system.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;

public class TeeThread
extends Thread {
    private static final Logger logger = Logger.get(TeeThread.class);
    private final InputStream source;
    private final ImmutableList<OutputStream> destinations;

    public TeeThread(InputStream source, OutputStream ... destinations) {
        super("Tee Thread");
        this.setDaemon(true);
        this.source = source;
        this.destinations = ImmutableList.copyOf(destinations);
    }

    @Override
    public void run() {
        block4: {
            try {
                int bytesRead;
                byte[] buf = new byte[4096];
                while ((bytesRead = this.source.read(buf)) > 0) {
                    for (OutputStream destination : this.destinations) {
                        destination.write(buf, 0, bytesRead);
                    }
                }
            }
            catch (IOException e) {
                if (this.source instanceof PipedInputStream) break block4;
                logger.err(e, "Could not read from the console source.", new Object[0]);
            }
        }
    }
}

