/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system;

import com.google.common.base.Charsets;
import com.lyndir.lhunath.opal.system.Shell;
import com.lyndir.lhunath.opal.system.dummy.NullOutputStream;
import com.lyndir.lhunath.opal.system.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;

@SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
public class WinReg {
    private static final Logger logger = Logger.get(WinReg.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSupported() {
        try (NullOutputStream out = new NullOutputStream();){
            boolean bl = Shell.waitFor(Shell.exec(out, out, new File("C:\\Windows\\System32"), "reg.exe", "query", "/?")) == 0;
            return bl;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @Nullable
    public static <T> T query(String key, String value, Class<T> type) {
        if (!type.equals(String.class) && !type.equals(Integer.class)) {
            throw new IllegalArgumentException("Can only query the registry for String or Integer types.");
        }
        String output = Shell.execRead(Charsets.UTF_8, new File("C:\\Windows\\System32"), "reg.exe", "query", key, "/v", value);
        if (output == null) {
            return null;
        }
        T result = null;
        if (type.equals(String.class)) {
            int pos = output.indexOf("REG_SZ") + "REG_SZ".length();
            if (pos < 6) {
                logger.wrn("Key %s:%s not found!", key, value);
                return type.cast("");
            }
            result = type.cast(output.substring(pos).trim());
        } else if (type.equals(Integer.class)) {
            int pos = output.indexOf("REG_DWORD") + "REG_DWORD".length();
            result = type.cast(Integer.parseInt(output.substring(pos).trim()));
        }
        return result;
    }
}

