/*
 * Decompiled with CFR 0.152.
 */
package com.lyndir.lhunath.opal.system.collection;

import com.lyndir.lhunath.opal.system.util.NNSupplier;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Cache {
    private static final Map<Object, Map<Object, Map<Object, SoftReference<Object>>>> cache = new WeakHashMap<Object, Map<Object, Map<Object, SoftReference<Object>>>>();

    public static <T> T getOrLoad(@Nonnull Object key, @Nonnull NNSupplier<T> loader) {
        return Cache.getOrLoad(key, null, null, loader);
    }

    public static <T> T getOrLoad(@Nonnull Object key1, @Nullable Object key2, @Nonnull NNSupplier<T> loader) {
        return Cache.getOrLoad(key1, key2, null, loader);
    }

    public static <T> T getOrLoad(@Nonnull Object key1, @Nullable Object key2, @Nullable Object key3, @Nonnull NNSupplier<T> loader) {
        Object object;
        SoftReference<Object> key3Cache;
        Map<Object, SoftReference<Object>> key2Cache;
        Map<Object, Map<Object, SoftReference<Object>>> key1Cache = cache.get(key1);
        if (key1Cache == null) {
            key1Cache = new WeakHashMap<Object, Map<Object, SoftReference<Object>>>();
            cache.put(key1, key1Cache);
        }
        if ((key2Cache = key1Cache.get(key2)) == null) {
            key2Cache = new WeakHashMap<Object, SoftReference<Object>>();
            key1Cache.put(key2, key2Cache);
        }
        if ((key3Cache = key2Cache.get(key3)) != null && (object = key3Cache.get()) != null) {
            return (T)object;
        }
        object = loader.get();
        key2Cache.put(key3, new SoftReference<Object>(object));
        return (T)object;
    }
}

